/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler.advice;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.handler.advice.AbstractRequestHandlerAdvice;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class LockRequestHandlerAdvice
extends AbstractRequestHandlerAdvice {
    private final LockRegistry lockRegistry;
    private final Expression lockKeyExpression;
    @Nullable
    private MessageChannel discardChannel;
    @Nullable
    private Expression waitLockDurationExpression;
    private EvaluationContext evaluationContext;

    public LockRequestHandlerAdvice(LockRegistry lockRegistry, Object lockKey) {
        this(lockRegistry, new ValueExpression<Object>(lockKey));
    }

    public LockRequestHandlerAdvice(LockRegistry lockRegistry, Expression lockKeyExpression) {
        Assert.notNull((Object)lockRegistry, (String)"'lockRegistry' must not be null");
        Assert.notNull((Object)lockKeyExpression, (String)"'lockKeyExpression' must not be null");
        this.lockRegistry = lockRegistry;
        this.lockKeyExpression = lockKeyExpression;
    }

    public LockRequestHandlerAdvice(LockRegistry lockRegistry, Function<Message<?>, Object> lockKeyFunction) {
        Assert.notNull((Object)lockRegistry, (String)"'lockRegistry' must not be null");
        Assert.notNull(lockKeyFunction, (String)"'lockKeyFunction' must not be null");
        this.lockRegistry = lockRegistry;
        this.lockKeyExpression = new FunctionExpression(lockKeyFunction);
    }

    public void setWaitLockDuration(Duration waitLockDuration) {
        this.setWaitLockDurationExpression(new ValueExpression<Duration>(waitLockDuration));
    }

    public void setWaitLockDurationExpression(Expression waitLockDurationExpression) {
        this.waitLockDurationExpression = waitLockDurationExpression;
    }

    public void setWaitLockDurationExpressionString(String waitLockDurationExpression) {
        this.waitLockDurationExpression = EXPRESSION_PARSER.parseExpression(waitLockDurationExpression);
    }

    public void setWaitLockDurationFunction(Function<Message<?>, Duration> waitLockDurationFunction) {
        this.waitLockDurationExpression = new FunctionExpression(waitLockDurationFunction);
    }

    public void setDiscardChannel(@Nullable MessageChannel discardChannel) {
        this.discardChannel = discardChannel;
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.evaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
    }

    @Override
    protected Object doInvoke(AbstractRequestHandlerAdvice.ExecutionCallback callback, Object target, Message<?> message) {
        Object lockKey = this.lockKeyExpression.getValue(this.evaluationContext, message);
        if (lockKey != null) {
            Duration waitLockDuration = this.getWaitLockDuration(message);
            try {
                if (waitLockDuration == null) {
                    return this.lockRegistry.executeLocked(lockKey, callback::execute);
                }
                return this.lockRegistry.executeLocked(lockKey, waitLockDuration, callback::execute);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "The lock for message was interrupted", ex);
            }
            catch (TimeoutException ex) {
                throw IntegrationUtils.wrapInHandlingExceptionIfNecessary(message, () -> "Could not acquire the lock in time: " + String.valueOf(waitLockDuration), ex);
            }
        }
        if (this.discardChannel != null) {
            this.discardChannel.send(message);
            return null;
        }
        return callback.execute();
    }

    @Nullable
    private Duration getWaitLockDuration(Message<?> message) {
        Object value;
        if (this.waitLockDurationExpression != null && (value = this.waitLockDurationExpression.getValue(this.evaluationContext, message)) != null) {
            if (value instanceof Duration) {
                Duration duration = (Duration)value;
                return duration;
            }
            if (value instanceof Long) {
                Long aLong = (Long)value;
                return Duration.ofMillis(aLong);
            }
            return Duration.parse(value.toString());
        }
        return null;
    }
}

