/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.function.Function;

@FunctionalInterface
public interface CheckedFunction<T, R, E extends Throwable> {
    public R apply(T var1) throws E;

    default public Function<T, R> unchecked() {
        return t1 -> {
            try {
                return this.apply(t1);
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)t;
                    throw runtimeException;
                }
                if (t instanceof Error) {
                    Error error = (Error)t;
                    throw error;
                }
                throw new IllegalStateException(t);
            }
        };
    }
}

