/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import java.util.HashSet;
import java.util.Set;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPath;
import org.hibernate.metamodel.mapping.ordering.ast.DomainPathContinuation;
import org.hibernate.metamodel.mapping.ordering.ast.PathResolutionException;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.spi.NavigablePath;

public class FkDomainPathContinuation
extends DomainPathContinuation {
    private final Set<String> possiblePaths;

    public FkDomainPathContinuation(NavigablePath navigablePath, DomainPath lhs, ToOneAttributeMapping referencedModelPart) {
        super(navigablePath, lhs, referencedModelPart);
        this.possiblePaths = referencedModelPart.getTargetKeyPropertyNames();
    }

    public FkDomainPathContinuation(NavigablePath navigablePath, DomainPath lhs, ModelPart referencedModelPart, Set<String> possiblePaths) {
        super(navigablePath, lhs, referencedModelPart);
        this.possiblePaths = possiblePaths;
    }

    @Override
    public SequencePart resolvePathPart(String name, String identifier, boolean isTerminal, TranslationContext translationContext) {
        if (!this.possiblePaths.contains(name)) {
            throw new PathResolutionException("Domain path of type `" + String.valueOf(this.referencedModelPart.getPartMappingType()) + "` -> `" + name + "`");
        }
        HashSet<String> furtherPaths = new HashSet<String>();
        for (String possiblePath : this.possiblePaths) {
            if (!possiblePath.startsWith(name) || possiblePath.length() <= name.length() || possiblePath.charAt(name.length()) != '.') continue;
            furtherPaths.add(possiblePath.substring(name.length() + 2));
        }
        return new FkDomainPathContinuation(this.navigablePath.append(name), this, ((ModelPartContainer)this.referencedModelPart).findSubPart(name, null), furtherPaths);
    }
}

