/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;

public class MustChangePasswordFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof SecurityContextHolderAwareRequestWrapper) {
            boolean isMustChangePassword = SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(authority -> "MUST_CHANGE_PASSWORD".equals(authority.getAuthority()));
            SecurityContextHolderAwareRequestWrapper wrappedRequest = (SecurityContextHolderAwareRequestWrapper)SecurityContextHolderAwareRequestWrapper.class.cast(request);
            if (isMustChangePassword && !"POST".equalsIgnoreCase(wrappedRequest.getMethod()) && !"/users/self/changePassword".equals(wrappedRequest.getPathInfo())) {
                throw new AccessDeniedException("Please change your password first");
            }
        }
        chain.doFilter(request, response);
    }
}

