/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.saml2;

import com.google.common.collect.Iterables;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.pac4j.saml.Pac4jSamlClientProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.pac4j.client.DelegatedIdentityProviderFactory;
import org.apereo.cas.support.pac4j.authentication.attributes.GroovyAttributeConverter;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClient;
import org.apereo.cas.support.pac4j.authentication.clients.ConfigurableDelegatedClientBuilder;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.ext.saml2mdui.DisplayName;
import org.opensaml.saml.ext.saml2mdui.UIInfo;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.processor.LogoutProcessor;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.generator.ValueGenerator;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.context.SAML2ContextProvider;
import org.pac4j.saml.context.SAMLContextProvider;
import org.pac4j.saml.logout.SAML2LogoutActionBuilder;
import org.pac4j.saml.logout.processor.SAML2LogoutProcessor;
import org.pac4j.saml.metadata.DefaultSAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2DelegatingMetadataResolver;
import org.pac4j.saml.metadata.SAML2InMemoryMetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.redirect.SAML2RedirectionActionBuilder;
import org.pac4j.saml.sso.artifact.DefaultSOAPPipelineProvider;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.state.SAML2StateGenerator;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.HttpSessionStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

public class DelegatedClientSaml2Builder
implements ConfigurableDelegatedClientBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatedClientSaml2Builder.class);
    protected final CasSSLContext casSslContext;
    protected final ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory;
    protected final OpenSamlConfigBean configBean;

    public List<ConfigurableDelegatedClient> build(CasConfigurationProperties casProperties) {
        return this.buildSaml2IdentityProviders(casProperties);
    }

    protected List<ConfigurableDelegatedClient> buildSaml2IdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Optional scriptFactory = ExecutableCompiledScriptFactory.findExecutableCompiledScriptFactory();
        return pac4jProperties.getSaml().stream().filter(saml -> saml.isEnabled() && StringUtils.isNotBlank((CharSequence)saml.getMetadata().getIdentityProviderMetadataPath()) && StringUtils.isNotBlank((CharSequence)saml.getServiceProviderEntityId())).map(saml -> {
            List mappedAttributes;
            String keystorePath = SpringExpressionLanguageValueResolver.getInstance().resolve((String)StringUtils.defaultIfBlank((CharSequence)saml.getKeystorePath(), (CharSequence)Beans.getTempFilePath((String)"samlSpKeystore", (String)".jks")));
            String identityProviderMetadataPath = SpringExpressionLanguageValueResolver.getInstance().resolve(saml.getMetadata().getIdentityProviderMetadataPath());
            LOGGER.debug("Creating SAML2 identity provider [{}] with identity provider metadata [{}]", (Object)saml.getClientName(), (Object)identityProviderMetadataPath);
            SAML2Configuration configuration = new SAML2Configuration(keystorePath, saml.getKeystorePassword(), saml.getPrivateKeyPassword(), identityProviderMetadataPath);
            configuration.setForceKeystoreGeneration(saml.isForceKeystoreGeneration());
            FunctionUtils.doIf((saml.getCertificateExpirationDays() > 0 ? 1 : 0) != 0, __ -> configuration.setCertificateExpirationPeriod(Period.ofDays(saml.getCertificateExpirationDays()))).accept(saml);
            FunctionUtils.doIfNotNull((Object)saml.getResponseBindingType(), arg_0 -> ((SAML2Configuration)configuration).setResponseBindingType(arg_0));
            FunctionUtils.doIfNotNull((Object)saml.getCertificateSignatureAlg(), arg_0 -> ((SAML2Configuration)configuration).setCertificateSignatureAlg(arg_0));
            configuration.setPartialLogoutTreatedAsSuccess(saml.isPartialLogoutAsSuccess());
            configuration.setResponseDestinationAttributeMandatory(saml.isResponseDestinationMandatory());
            configuration.setSupportedProtocols(saml.getSupportedProtocols());
            FunctionUtils.doIfNotBlank((CharSequence)saml.getRequestInitiatorUrl(), __ -> configuration.setRequestInitiatorUrl(saml.getRequestInitiatorUrl()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getSingleLogoutServiceUrl(), __ -> configuration.setSingleSignOutServiceUrl(saml.getSingleLogoutServiceUrl()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getLogoutResponseBindingType(), __ -> configuration.setSpLogoutResponseBindingType(saml.getLogoutResponseBindingType()));
            configuration.setCertificateNameToAppend((String)StringUtils.defaultIfBlank((CharSequence)saml.getCertificateNameToAppend(), (CharSequence)saml.getClientName()));
            configuration.setMaximumAuthenticationLifetime(Beans.newDuration((String)saml.getMaximumAuthenticationLifetime()).toSeconds());
            String serviceProviderEntityId = SpringExpressionLanguageValueResolver.getInstance().resolve(saml.getServiceProviderEntityId());
            configuration.setServiceProviderEntityId(serviceProviderEntityId);
            String samlSpMetadata = (String)StringUtils.defaultIfBlank((CharSequence)saml.getMetadata().getServiceProvider().getFileSystem().getLocation(), (CharSequence)Beans.getTempFilePath((String)"samlSpMetadata", (String)".xml"));
            FunctionUtils.doIfNotNull((Object)samlSpMetadata, location -> {
                AbstractResource resource = ResourceUtils.getRawResourceFrom((String)location);
                LOGGER.debug("Service provider metadata is located at [{}] with entity id [{}]", (Object)resource, (Object)serviceProviderEntityId);
                configuration.setServiceProviderMetadataResource((Resource)resource);
            });
            configuration.setAuthnRequestBindingType(saml.getDestinationBinding());
            configuration.setSpLogoutRequestBindingType(saml.getLogoutRequestBinding());
            configuration.setForceAuth(saml.isForceAuth());
            configuration.setPassive(saml.isPassive());
            configuration.setSignMetadata(saml.isSignServiceProviderMetadata());
            configuration.setMetadataSigner((SAML2MetadataSigner)new DefaultSAML2MetadataSigner(configuration));
            configuration.setAuthnRequestSigned(saml.isSignAuthnRequest());
            configuration.setSpLogoutRequestSigned(saml.isSignServiceProviderLogoutRequest());
            configuration.setAcceptedSkew(Beans.newDuration((String)saml.getAcceptedSkew()).toSeconds());
            configuration.setSslSocketFactory(this.casSslContext.getSslContext().getSocketFactory());
            configuration.setHostnameVerifier(this.casSslContext.getHostnameVerifier());
            FunctionUtils.doIfNotBlank((CharSequence)saml.getPrincipalIdAttribute(), __ -> configuration.setAttributeAsId(saml.getPrincipalIdAttribute()));
            FunctionUtils.doIfNotBlank((CharSequence)saml.getNameIdAttribute(), __ -> configuration.setNameIdAttribute(saml.getNameIdAttribute()));
            configuration.setWantsAssertionsSigned(saml.isWantsAssertionsSigned());
            configuration.setWantsResponsesSigned(saml.isWantsResponsesSigned());
            configuration.setAllSignatureValidationDisabled(saml.isAllSignatureValidationDisabled());
            configuration.setUseNameQualifier(saml.isUseNameQualifier());
            configuration.setAttributeConsumingServiceIndex(saml.getAttributeConsumingServiceIndex());
            Optional.ofNullable((SAMLMessageStoreFactory)this.samlMessageStoreFactory.getIfAvailable()).ifPresentOrElse(arg_0 -> ((SAML2Configuration)configuration).setSamlMessageStoreFactory(arg_0), () -> {
                FunctionUtils.doIf((boolean)"EMPTY".equalsIgnoreCase(saml.getMessageStoreFactory()), ig -> configuration.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new EmptyStoreFactory())).accept(saml);
                FunctionUtils.doIf((boolean)"SESSION".equalsIgnoreCase(saml.getMessageStoreFactory()), ig -> configuration.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new HttpSessionStoreFactory())).accept(saml);
                if (saml.getMessageStoreFactory().contains(".")) {
                    FunctionUtils.doAndHandle(__ -> {
                        Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getMessageStoreFactory());
                        SAMLMessageStoreFactory factory = (SAMLMessageStoreFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        configuration.setSamlMessageStoreFactory(factory);
                    });
                }
            });
            FunctionUtils.doIf((saml.getAssertionConsumerServiceIndex() >= 0 ? 1 : 0) != 0, __ -> configuration.setAssertionConsumerServiceIndex(saml.getAssertionConsumerServiceIndex())).accept(saml);
            if (!saml.getAuthnContextClassRef().isEmpty()) {
                configuration.setComparisonType(saml.getAuthnContextComparisonType().toUpperCase(Locale.ENGLISH));
                configuration.setAuthnContextClassRefs(saml.getAuthnContextClassRef());
            }
            FunctionUtils.doIfNotBlank((CharSequence)saml.getNameIdPolicyFormat(), __ -> configuration.setNameIdPolicyFormat(saml.getNameIdPolicyFormat()));
            if (!saml.getRequestedAttributes().isEmpty()) {
                saml.getRequestedAttributes().stream().map(attribute -> new SAML2ServiceProviderRequestedAttribute(attribute.getName(), attribute.getFriendlyName(), attribute.getNameFormat(), attribute.isRequired())).forEach(attribute -> configuration.getRequestedServiceProviderAttributes().add(attribute));
            }
            if (!saml.getBlockedSignatureSigningAlgorithms().isEmpty()) {
                configuration.setBlackListedSignatureSigningAlgorithms((Collection)saml.getBlockedSignatureSigningAlgorithms());
            }
            if (!saml.getSignatureAlgorithms().isEmpty()) {
                configuration.setSignatureAlgorithms(saml.getSignatureAlgorithms());
            }
            if (!saml.getSignatureReferenceDigestMethods().isEmpty()) {
                configuration.setSignatureReferenceDigestMethods(saml.getSignatureReferenceDigestMethods());
            }
            FunctionUtils.doIfNotBlank((CharSequence)saml.getSignatureCanonicalizationAlgorithm(), __ -> configuration.setSignatureCanonicalizationAlgorithm(saml.getSignatureCanonicalizationAlgorithm()));
            configuration.setProviderName(saml.getProviderName());
            configuration.setNameIdPolicyAllowCreate(saml.getNameIdPolicyAllowCreate().toBoolean());
            if (StringUtils.isNotBlank((CharSequence)saml.getSaml2AttributeConverter())) {
                if (scriptFactory.isPresent() && ((ExecutableCompiledScriptFactory)scriptFactory.get()).isExternalScript(saml.getSaml2AttributeConverter())) {
                    FunctionUtils.doAndHandle(__ -> {
                        AbstractResource resource = ResourceUtils.getResourceFrom((String)saml.getSaml2AttributeConverter());
                        ExecutableCompiledScript script = ((ExecutableCompiledScriptFactory)scriptFactory.get()).fromResource((Resource)resource);
                        configuration.setSamlAttributeConverter((AttributeConverter)new GroovyAttributeConverter(script));
                    });
                } else {
                    FunctionUtils.doAndHandle(__ -> {
                        Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getSaml2AttributeConverter());
                        AttributeConverter converter = (AttributeConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        configuration.setSamlAttributeConverter(converter);
                    });
                }
            }
            if (!(mappedAttributes = saml.getMappedAttributes()).isEmpty()) {
                configuration.setMappedAttributes(CollectionUtils.convertDirectedListToMap((Collection)mappedAttributes));
            }
            SAML2Client client = new SAML2Client(configuration);
            LOGGER.debug("Created SAML2 delegated client [{}]", (Object)client);
            return new ConfigurableDelegatedClient((BaseClient)client, (Pac4jBaseClientProperties)saml);
        }).collect(Collectors.toList());
    }

    public List<? extends BaseClient> configure(BaseClient client, Pac4jBaseClientProperties clientProperties, CasConfigurationProperties properties) throws Exception {
        if (client instanceof SAML2Client) {
            Pac4jSamlClientProperties saml2Properties;
            SAML2Client saml2Client = (SAML2Client)client;
            if (clientProperties instanceof Pac4jSamlClientProperties && (saml2Properties = (Pac4jSamlClientProperties)clientProperties).getMetadata().isIdentityProviderMetadataAggregate()) {
                LOGGER.info("Loading SAML2 identity provider metadata from [{}]", (Object)saml2Properties.getMetadata().getIdentityProviderMetadataPath());
                saml2Client.init();
                LOGGER.info("Loaded SAML2 identity provider metadata from [{}]", (Object)saml2Properties.getMetadata().getIdentityProviderMetadataPath());
                SAML2MetadataResolver idpMetadataResolver = saml2Client.getIdentityProviderMetadataResolver();
                MetadataResolver metadataResolver = idpMetadataResolver.resolve();
                Iterable providers = metadataResolver.resolve((Object)new CriteriaSet(new Criterion[]{new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME)}));
                if (Iterables.size((Iterable)providers) > 1) {
                    StopWatch stopWatch = new StopWatch();
                    stopWatch.start();
                    ArrayList<SAML2Client> results = new ArrayList<SAML2Client>();
                    try (ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();){
                        List<Future> futures = ((Stream)Arrays.stream((EntityDescriptor[])Iterables.toArray((Iterable)providers, EntityDescriptor.class)).parallel()).map(entityDescriptor -> executor.submit(() -> this.buildSaml2ClientFromAggregate(saml2Client, (EntityDescriptor)entityDescriptor, saml2Properties, properties))).toList();
                        for (Future future : futures) {
                            results.add((SAML2Client)future.get());
                        }
                        executor.shutdown();
                    }
                    stopWatch.stop();
                    LOGGER.info("Loaded [{}] SAML2 identity provider metadata in [{}]", (Object)results.size(), (Object)stopWatch.getDuration());
                    return results;
                }
            }
        }
        return super.configure(client, clientProperties, properties);
    }

    protected SAML2Client buildSaml2ClientFromAggregate(SAML2Client saml2Client, EntityDescriptor entityDescriptor, Pac4jSamlClientProperties saml2Properties, CasConfigurationProperties properties) {
        SAML2Configuration configuration = saml2Client.getConfiguration();
        LOGGER.trace("Loading SAML2 client for identity provider with entity id [{}]", (Object)entityDescriptor.getEntityID());
        SAML2Configuration singleConfiguration = DelegatedClientSaml2Builder.createSaml2Configuration(entityDescriptor, configuration);
        SAML2Client singleClient = DelegatedClientSaml2Builder.createSaml2Client(saml2Client, singleConfiguration);
        String clientName = saml2Client.getName() + "-" + RandomUtils.nextLong();
        DelegatedIdentityProviderFactory.configureClientName((BaseClient)singleClient, (String)clientName);
        DelegatedIdentityProviderFactory.configureClientCustomProperties((BaseClient)singleClient, (Pac4jBaseClientProperties)saml2Properties);
        DelegatedIdentityProviderFactory.configureClientCallbackUrl((BaseClient)singleClient, (Pac4jBaseClientProperties)saml2Properties, (String)properties.getServer().getLoginUrl());
        singleClient.getCustomProperties().put("identityProviderMetadataAggregate", true);
        IDPSSODescriptor idpSSODescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        Optional.ofNullable(idpSSODescriptor).map(RoleDescriptor::getExtensions).map(ext -> ext.getUnknownXMLObjects(UIInfo.DEFAULT_ELEMENT_NAME)).stream().flatMap(Collection::stream).map(UIInfo.class::cast).filter(uiInfo -> !uiInfo.getDisplayNames().isEmpty()).map(uiInfo -> ((DisplayName)uiInfo.getDisplayNames().getFirst()).getValue()).filter(StringUtils::isNotBlank).findFirst().ifPresent(value -> singleClient.getCustomProperties().put("displayName", value));
        singleClient.init();
        return singleClient;
    }

    private static SAML2Configuration createSaml2Configuration(EntityDescriptor entityDescriptor, SAML2Configuration configuration) {
        SAML2Configuration singleConfiguration = configuration.withMetadataGenerator((SAML2MetadataGenerator)new SAML2InMemoryMetadataGenerator());
        singleConfiguration.setIdentityProviderEntityId(entityDescriptor.getEntityID());
        singleConfiguration.setIdentityProviderMetadataResolver((SAML2MetadataResolver)new SAML2DelegatingMetadataResolver(entityDescriptor));
        singleConfiguration.setCredentialProvider(configuration.getCredentialProvider());
        return singleConfiguration;
    }

    private static SAML2Client createSaml2Client(SAML2Client saml2Client, SAML2Configuration singleConfiguration) {
        SAML2Client singleClient = new SAML2Client(singleConfiguration);
        singleClient.setDecrypter(saml2Client.getDecrypter());
        singleClient.setSignatureSigningParametersProvider(saml2Client.getSignatureSigningParametersProvider());
        SAML2ContextProvider contextProvider = new SAML2ContextProvider(singleConfiguration.getIdentityProviderMetadataResolver(), saml2Client.getServiceProviderMetadataResolver(), saml2Client.getConfiguration().getSamlMessageStoreFactory());
        singleClient.setContextProvider((SAMLContextProvider)contextProvider);
        singleClient.setSignatureSigningParametersProvider(saml2Client.getSignatureSigningParametersProvider());
        singleClient.setReplayCache(saml2Client.getReplayCache());
        singleClient.setAuthnResponseValidator(saml2Client.getAuthnResponseValidator());
        singleClient.setSoapPipelineProvider((SOAPPipelineProvider)new DefaultSOAPPipelineProvider(singleClient));
        singleClient.setLogoutValidator(saml2Client.getLogoutValidator());
        singleClient.setRedirectionActionBuilder((RedirectionActionBuilder)new SAML2RedirectionActionBuilder(singleClient));
        singleClient.setCredentialsExtractor(saml2Client.getCredentialsExtractor());
        singleClient.setAuthenticator(saml2Client.getAuthenticator());
        singleClient.setLogoutProcessor((LogoutProcessor)new SAML2LogoutProcessor(singleClient));
        singleClient.setLogoutActionBuilder((LogoutActionBuilder)new SAML2LogoutActionBuilder(singleClient));
        singleClient.setServiceProviderMetadataResolver(saml2Client.getServiceProviderMetadataResolver());
        singleClient.setStateGenerator((ValueGenerator)new SAML2StateGenerator(singleClient));
        singleClient.setWebSsoMessageSender(saml2Client.getWebSsoMessageSender());
        singleClient.setLogoutRequestMessageSender(saml2Client.getLogoutRequestMessageSender());
        return singleClient;
    }

    @Generated
    public DelegatedClientSaml2Builder(CasSSLContext casSslContext, ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, OpenSamlConfigBean configBean) {
        this.casSslContext = casSslContext;
        this.samlMessageStoreFactory = samlMessageStoreFactory;
        this.configBean = configBean;
    }
}

