/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.multitenancy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.ConfigurationPropertiesBindingContext;
import org.apereo.cas.multitenancy.DefaultTenantAuthenticationPolicy;
import org.apereo.cas.multitenancy.DefaultTenantDelegatedAuthenticationPolicy;
import org.apereo.cas.multitenancy.DefaultTenantUserInterfacePolicy;
import org.apereo.cas.multitenancy.TenantAuthenticationPolicy;
import org.apereo.cas.multitenancy.TenantDelegatedAuthenticationPolicy;
import org.apereo.cas.multitenancy.TenantUserInterfacePolicy;
import org.apereo.cas.util.serialization.DecodableCipherMap;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class TenantDefinition
implements Serializable {
    private static final long serialVersionUID = -9012299259747093234L;
    private String id;
    private String description;
    @DecodableCipherMap
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private TenantAuthenticationPolicy authenticationPolicy = new DefaultTenantAuthenticationPolicy();
    private TenantUserInterfacePolicy userInterfacePolicy = new DefaultTenantUserInterfacePolicy();
    private TenantDelegatedAuthenticationPolicy delegatedAuthenticationPolicy = new DefaultTenantDelegatedAuthenticationPolicy();

    @JsonIgnore
    public <T> ConfigurationPropertiesBindingContext<T> bindPropertiesTo(Class<T> clazz) {
        return CasConfigurationProperties.bindFrom(this.properties, clazz);
    }

    @JsonIgnore
    public ConfigurationPropertiesBindingContext<CasConfigurationProperties> bindProperties() {
        return CasConfigurationProperties.bindFrom(this.properties);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public TenantAuthenticationPolicy getAuthenticationPolicy() {
        return this.authenticationPolicy;
    }

    @Generated
    public TenantUserInterfacePolicy getUserInterfacePolicy() {
        return this.userInterfacePolicy;
    }

    @Generated
    public TenantDelegatedAuthenticationPolicy getDelegatedAuthenticationPolicy() {
        return this.delegatedAuthenticationPolicy;
    }

    @Generated
    public TenantDefinition setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public TenantDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    @Generated
    public TenantDefinition setProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @Generated
    public TenantDefinition setAuthenticationPolicy(TenantAuthenticationPolicy authenticationPolicy) {
        this.authenticationPolicy = authenticationPolicy;
        return this;
    }

    @Generated
    public TenantDefinition setUserInterfacePolicy(TenantUserInterfacePolicy userInterfacePolicy) {
        this.userInterfacePolicy = userInterfacePolicy;
        return this;
    }

    @Generated
    public TenantDefinition setDelegatedAuthenticationPolicy(TenantDelegatedAuthenticationPolicy delegatedAuthenticationPolicy) {
        this.delegatedAuthenticationPolicy = delegatedAuthenticationPolicy;
        return this;
    }

    @Generated
    public String toString() {
        return "TenantDefinition(id=" + this.id + ", description=" + this.description + ", properties=" + String.valueOf(this.properties) + ", authenticationPolicy=" + String.valueOf(this.authenticationPolicy) + ", userInterfacePolicy=" + String.valueOf(this.userInterfacePolicy) + ", delegatedAuthenticationPolicy=" + String.valueOf(this.delegatedAuthenticationPolicy) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantDefinition)) {
            return false;
        }
        TenantDefinition other = (TenantDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$description = this.description;
        String other$description = other.description;
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, Object> this$properties = this.properties;
        Map<String, Object> other$properties = other.properties;
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        TenantAuthenticationPolicy this$authenticationPolicy = this.authenticationPolicy;
        TenantAuthenticationPolicy other$authenticationPolicy = other.authenticationPolicy;
        if (this$authenticationPolicy == null ? other$authenticationPolicy != null : !this$authenticationPolicy.equals(other$authenticationPolicy)) {
            return false;
        }
        TenantUserInterfacePolicy this$userInterfacePolicy = this.userInterfacePolicy;
        TenantUserInterfacePolicy other$userInterfacePolicy = other.userInterfacePolicy;
        if (this$userInterfacePolicy == null ? other$userInterfacePolicy != null : !this$userInterfacePolicy.equals(other$userInterfacePolicy)) {
            return false;
        }
        TenantDelegatedAuthenticationPolicy this$delegatedAuthenticationPolicy = this.delegatedAuthenticationPolicy;
        TenantDelegatedAuthenticationPolicy other$delegatedAuthenticationPolicy = other.delegatedAuthenticationPolicy;
        return !(this$delegatedAuthenticationPolicy == null ? other$delegatedAuthenticationPolicy != null : !this$delegatedAuthenticationPolicy.equals(other$delegatedAuthenticationPolicy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TenantDefinition;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $description = this.description;
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, Object> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        TenantAuthenticationPolicy $authenticationPolicy = this.authenticationPolicy;
        result = result * 59 + ($authenticationPolicy == null ? 43 : $authenticationPolicy.hashCode());
        TenantUserInterfacePolicy $userInterfacePolicy = this.userInterfacePolicy;
        result = result * 59 + ($userInterfacePolicy == null ? 43 : $userInterfacePolicy.hashCode());
        TenantDelegatedAuthenticationPolicy $delegatedAuthenticationPolicy = this.delegatedAuthenticationPolicy;
        result = result * 59 + ($delegatedAuthenticationPolicy == null ? 43 : $delegatedAuthenticationPolicy.hashCode());
        return result;
    }

    @Generated
    public TenantDefinition() {
    }
}

