/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.JSONControlDecodeHelper;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.AssertionRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityRequestControl;
import com.unboundid.ldap.sdk.controls.AuthorizationIdentityResponseControl;
import com.unboundid.ldap.sdk.controls.DraftLDUPSubentriesRequestControl;
import com.unboundid.ldap.sdk.controls.ManageDsaITRequestControl;
import com.unboundid.ldap.sdk.controls.MatchedValuesRequestControl;
import com.unboundid.ldap.sdk.controls.PasswordExpiredControl;
import com.unboundid.ldap.sdk.controls.PasswordExpiringControl;
import com.unboundid.ldap.sdk.controls.PermissiveModifyRequestControl;
import com.unboundid.ldap.sdk.controls.PostReadRequestControl;
import com.unboundid.ldap.sdk.controls.PostReadResponseControl;
import com.unboundid.ldap.sdk.controls.PreReadRequestControl;
import com.unboundid.ldap.sdk.controls.PreReadResponseControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV1RequestControl;
import com.unboundid.ldap.sdk.controls.ProxiedAuthorizationV2RequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortRequestControl;
import com.unboundid.ldap.sdk.controls.ServerSideSortResponseControl;
import com.unboundid.ldap.sdk.controls.SimplePagedResultsControl;
import com.unboundid.ldap.sdk.controls.SubtreeDeleteRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewRequestControl;
import com.unboundid.ldap.sdk.controls.VirtualListViewResponseControl;
import com.unboundid.ldap.sdk.experimental.ControlHelper;
import com.unboundid.ldap.sdk.forgerockds.controls.W3CTraceContextRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AccessLogFieldRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AccountUsableRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AccountUsableResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AdministrativeOperationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.AssuredReplicationResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ExcludeBranchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ExtendedSchemaInfoRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GenerateAccessTokenRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GenerateAccessTokenResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GeneratePasswordRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GeneratePasswordResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetAuthorizationEntryResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetBackendSetIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetBackendSetIDResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetEffectiveRightsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetPasswordPolicyStateIssuesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetPasswordPolicyStateIssuesResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetRecentLoginHistoryRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetRecentLoginHistoryResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetServerIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetServerIDResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.GetUserResourceLimitsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.HardDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IgnoreNoUserModificationRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.IntermediateClientResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JSONFormattedRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JSONFormattedResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.JoinResultControl;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.NameWithEntryUUIDRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.NoOpRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OperationPurposeRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.OverrideSearchLimitsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordPolicyResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordUpdateBehaviorRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PasswordValidationDetailsResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PermitUnindexedSearchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.PurgePasswordRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RealAttributesOnlyRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RejectUnindexedSearchRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReplicationRepairRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RetainIdentityRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RetirePasswordRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.ReturnConflictEntriesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToBackendSetRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.RouteToServerRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeleteResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SoftDeletedEntryAccessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressOperationalAttributeUpdateRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.SuppressReferentialIntegrityUpdatesRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.UndeleteRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessRequestControl;
import com.unboundid.ldap.sdk.unboundidds.controls.UniquenessResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.UnsolicitedCancelResponseControl;
import com.unboundid.ldap.sdk.unboundidds.controls.VirtualAttributesOnlyRequestControl;
import com.unboundid.util.Base64;
import com.unboundid.util.Debug;
import com.unboundid.util.Extensible;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;

@Extensible
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public class Control
implements Serializable {
    private static final byte CONTROLS_TYPE = -96;
    @NotNull
    static final ConcurrentHashMap<String, String> DECODEABLE_CONTROL_CLASS_NAMES = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<String, DecodeableControl> DECODEABLE_CONTROL_INSTANCES = new ConcurrentHashMap();
    private static final long serialVersionUID = 4440956109070220054L;
    @Nullable
    private final ASN1OctetString value;
    private final boolean isCritical;
    @NotNull
    private final String oid;

    protected Control() {
        this.oid = null;
        this.isCritical = true;
        this.value = null;
    }

    protected Control(@NotNull Control control) {
        this.oid = control.oid;
        this.isCritical = control.isCritical;
        this.value = control.value;
    }

    public Control(@NotNull String oid) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isCritical = false;
        this.value = null;
    }

    public Control(@NotNull String oid, boolean isCritical) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = null;
    }

    public Control(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) {
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.isCritical = isCritical;
        this.value = value;
    }

    @NotNull
    public final String getOID() {
        return this.oid;
    }

    public final boolean isCritical() {
        return this.isCritical;
    }

    public final boolean hasValue() {
        return this.value != null;
    }

    @Nullable
    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final void writeTo(@NotNull ASN1Buffer writer) {
        ASN1BufferSequence controlSequence = writer.beginSequence();
        writer.addOctetString(this.oid);
        if (this.isCritical) {
            writer.addBoolean(true);
        }
        if (this.value != null) {
            writer.addOctetString(this.value.getValue());
        }
        controlSequence.end();
    }

    @NotNull
    public final ASN1Sequence encode() {
        ArrayList<ASN1Element> elementList = new ArrayList<ASN1Element>(3);
        elementList.add(new ASN1OctetString(this.oid));
        if (this.isCritical) {
            elementList.add(new ASN1Boolean(this.isCritical));
        }
        if (this.value != null) {
            elementList.add(new ASN1OctetString(this.value.getValue()));
        }
        return new ASN1Sequence(elementList);
    }

    @NotNull
    public static Control readFrom(@NotNull ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence controlSequence = reader.beginSequence();
            String oid = reader.readString();
            boolean isCritical = false;
            ASN1OctetString value = null;
            block7: while (controlSequence.hasMoreElements()) {
                byte type = (byte)reader.peek();
                switch (type) {
                    case 1: {
                        isCritical = reader.readBoolean();
                        continue block7;
                    }
                    case 4: {
                        value = new ASN1OctetString(reader.readBytes());
                        continue block7;
                    }
                }
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_INVALID_TYPE.get(StaticUtils.toHex(type)));
            }
            return Control.decode(oid, isCritical, value);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public static Control decode(@NotNull ASN1Sequence controlSequence) throws LDAPException {
        ASN1OctetString value;
        boolean isCritical;
        String oid;
        block10: {
            ASN1Element[] elements;
            block11: {
                elements = controlSequence.elements();
                if (elements.length < 1 || elements.length > 3) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_INVALID_ELEMENT_COUNT.get(elements.length));
                }
                oid = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
                isCritical = false;
                value = null;
                if (elements.length != 2) break block11;
                switch (elements[1].getType()) {
                    case 1: {
                        try {
                            isCritical = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
                            break block10;
                        }
                        catch (ASN1Exception ae) {
                            Debug.debugException(ae);
                            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_CRITICALITY.get(StaticUtils.getExceptionMessage(ae)), ae);
                        }
                    }
                    case 4: {
                        value = ASN1OctetString.decodeAsOctetString(elements[1]);
                        break block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_INVALID_TYPE.get(StaticUtils.toHex(elements[1].getType())));
                    }
                }
            }
            if (elements.length == 3) {
                try {
                    isCritical = ASN1Boolean.decodeAsBoolean(elements[1]).booleanValue();
                }
                catch (ASN1Exception ae) {
                    Debug.debugException(ae);
                    throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_DECODE_CRITICALITY.get(StaticUtils.getExceptionMessage(ae)), ae);
                }
                value = ASN1OctetString.decodeAsOctetString(elements[2]);
            }
        }
        return Control.decode(oid, isCritical, value);
    }

    @NotNull
    public static Control decode(@NotNull String oid, boolean isCritical, @Nullable ASN1OctetString value) throws LDAPException {
        DecodeableControl decodeableControl = DECODEABLE_CONTROL_INSTANCES.get(oid);
        if (decodeableControl == null) {
            String controlClassName = DECODEABLE_CONTROL_CLASS_NAMES.get(oid);
            if (controlClassName == null) {
                return new Control(oid, isCritical, value);
            }
            try {
                Class<?> controlClass = Class.forName(controlClassName);
                Constructor<?> noArgumentConstructor = controlClass.getDeclaredConstructor(new Class[0]);
                noArgumentConstructor.setAccessible(true);
                decodeableControl = (DecodeableControl)noArgumentConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.debugException(e);
                return new Control(oid, isCritical, value);
            }
        }
        try {
            return decodeableControl.decodeControl(oid, isCritical, value);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return new Control(oid, isCritical, value);
        }
    }

    @NotNull
    public static ASN1Sequence encodeControls(@NotNull Control[] controls) {
        ASN1Element[] controlElements = new ASN1Sequence[controls.length];
        for (int i = 0; i < controls.length; ++i) {
            controlElements[i] = controls[i].encode();
        }
        return new ASN1Sequence(-96, controlElements);
    }

    @NotNull
    public static Control[] decodeControls(@NotNull ASN1Sequence controlSequence) throws LDAPException {
        ASN1Element[] controlElements = controlSequence.elements();
        Control[] controls = new Control[controlElements.length];
        for (int i = 0; i < controlElements.length; ++i) {
            try {
                controls[i] = Control.decode(ASN1Sequence.decodeAsSequence(controlElements[i]));
                continue;
            }
            catch (ASN1Exception ae) {
                Debug.debugException(ae);
                throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROLS_DECODE_ELEMENT_NOT_SEQUENCE.get(StaticUtils.getExceptionMessage(ae)), ae);
            }
        }
        return controls;
    }

    public static void registerDecodeableControl(@NotNull String oid, @NotNull String className) {
        DECODEABLE_CONTROL_CLASS_NAMES.put(oid, className);
        DECODEABLE_CONTROL_INSTANCES.remove(oid);
    }

    public static void registerDecodeableControl(@NotNull String oid, @NotNull DecodeableControl controlInstance) {
        DECODEABLE_CONTROL_CLASS_NAMES.put(oid, controlInstance.getClass().getName());
        DECODEABLE_CONTROL_INSTANCES.put(oid, controlInstance);
    }

    public static void deregisterDecodeableControl(@NotNull String oid) {
        DECODEABLE_CONTROL_CLASS_NAMES.remove(oid);
        DECODEABLE_CONTROL_INSTANCES.remove(oid);
    }

    public final int hashCode() {
        int hashCode = this.oid.hashCode();
        if (this.isCritical) {
            ++hashCode;
        }
        if (this.value != null) {
            hashCode += this.value.hashCode();
        }
        return hashCode;
    }

    public final boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Control)) {
            return false;
        }
        Control c = (Control)o;
        if (!this.oid.equals(c.oid)) {
            return false;
        }
        if (this.isCritical != c.isCritical) {
            return false;
        }
        if (this.value == null) {
            if (c.value != null) {
                return false;
            }
        } else {
            if (c.value == null) {
                return false;
            }
            if (!this.value.equals(c.value)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public String getControlName() {
        return this.oid;
    }

    @NotNull
    public JSONObject toJSONControl() {
        LinkedHashMap<String, JSONValue> fields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(4));
        fields.put("oid", new JSONString(this.oid));
        String name = this.getControlName();
        if (name != null && !name.equals(this.oid)) {
            fields.put("control-name", new JSONString(name));
        }
        fields.put("criticality", new JSONBoolean(this.isCritical));
        if (this.value != null) {
            fields.put("value-base64", new JSONString(Base64.encode(this.value.getValue())));
        }
        return new JSONObject(fields);
    }

    @NotNull
    public static Control decodeJSONControl(@NotNull JSONObject controlObject, boolean strict, boolean isRequestControl) throws LDAPException {
        String oid = controlObject.getFieldAsString("oid");
        if (oid == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_JSON_OBJECT_MISSING_OID.get(controlObject.toSingleLineString(), "oid"));
        }
        switch (oid) {
            case "1.3.6.1.4.1.30221.2.5.66": {
                return AccessLogFieldRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.42.2.27.9.5.8": {
                if (isRequestControl) {
                    return AccountUsableRequestControl.decodeJSONControl(controlObject, strict);
                }
                return AccountUsableResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.11": {
                return AdministrativeOperationRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.1.12": {
                return AssertionRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.28": {
                return AssuredReplicationRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.29": {
                return AssuredReplicationResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.16": {
                return AuthorizationIdentityRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.15": {
                return AuthorizationIdentityResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.7628.5.101.1": {
                return DraftLDUPSubentriesRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.17": {
                return ExcludeBranchRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.12": {
                return ExtendedSchemaInfoRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.67": {
                return GenerateAccessTokenRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.68": {
                return GenerateAccessTokenResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.58": {
                return GeneratePasswordRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.59": {
                return GeneratePasswordResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.6": {
                if (isRequestControl) {
                    return GetAuthorizationEntryRequestControl.decodeJSONControl(controlObject, strict);
                }
                return GetAuthorizationEntryResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.33": {
                return GetBackendSetIDRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.34": {
                return GetBackendSetIDResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.42.2.27.9.5.2": {
                return GetEffectiveRightsRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.46": {
                return GetPasswordPolicyStateIssuesRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.47": {
                return GetPasswordPolicyStateIssuesResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.61": {
                return GetRecentLoginHistoryRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.62": {
                return GetRecentLoginHistoryResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.14": {
                return GetServerIDRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.15": {
                return GetServerIDResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.25": {
                return GetUserResourceLimitsRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.26": {
                return GetUserResourceLimitsResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.22": {
                return HardDeleteRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.5": {
                return IgnoreNoUserModificationRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.2": {
                if (isRequestControl) {
                    return IntermediateClientRequestControl.decodeJSONControl(controlObject, strict);
                }
                return IntermediateClientResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.9": {
                if (isRequestControl) {
                    return JoinRequestControl.decodeJSONControl(controlObject, strict);
                }
                return JoinResultControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.64": {
                return JSONFormattedRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.65": {
                return JSONFormattedResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.2": {
                return ManageDsaITRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.826.0.1.3344810.2.3": {
                return MatchedValuesRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.36": {
                return MatchingEntryCountRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.37": {
                return MatchingEntryCountResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.44": {
                return NameWithEntryUUIDRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.4203.1.10.2": {
                return NoOpRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.19": {
                return OperationPurposeRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.56": {
                return OverrideSearchLimitsRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.4": {
                return PasswordExpiredControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.5": {
                return PasswordExpiringControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.42.2.27.8.5.1": {
                if (isRequestControl) {
                    return PasswordPolicyRequestControl.decodeJSONControl(controlObject, strict);
                }
                return PasswordPolicyResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.51": {
                return PasswordUpdateBehaviorRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.40": {
                return PasswordValidationDetailsRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.41": {
                return PasswordValidationDetailsResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.840.113556.1.4.1413": {
                return PermissiveModifyRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.55": {
                return PermitUnindexedSearchRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.1.13.2": {
                if (isRequestControl) {
                    return PostReadRequestControl.decodeJSONControl(controlObject, strict);
                }
                return PostReadResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.1.13.1": {
                if (isRequestControl) {
                    return PreReadRequestControl.decodeJSONControl(controlObject, strict);
                }
                return PreReadResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.12": {
                return ProxiedAuthorizationV1RequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.18": {
                return ProxiedAuthorizationV2RequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.32": {
                return PurgePasswordRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.17": {
                return RealAttributesOnlyRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.54": {
                return RejectUnindexedSearchRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.1.5.2": {
                return ReplicationRepairRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.3": {
                return RetainIdentityRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.31": {
                return RetirePasswordRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.13": {
                return ReturnConflictEntriesRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.35": {
                return RouteToBackendSetRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.16": {
                return RouteToServerRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.840.113556.1.4.473": {
                return ServerSideSortRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.840.113556.1.4.474": {
                return ServerSideSortResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.840.113556.1.4.319": {
                return SimplePagedResultsControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.24": {
                return SoftDeletedEntryAccessRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.20": {
                return SoftDeleteRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.21": {
                return SoftDeleteResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.2.840.113556.1.4.805": {
                return SubtreeDeleteRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.27": {
                return SuppressOperationalAttributeUpdateRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.30": {
                return SuppressReferentialIntegrityUpdatesRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.23": {
                return UndeleteRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.52": {
                return UniquenessRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.53": {
                return UniquenessResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.30221.2.5.7": {
                return UnsolicitedCancelResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.19": {
                return VirtualAttributesOnlyRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.9": {
                return VirtualListViewRequestControl.decodeJSONControl(controlObject, strict);
            }
            case "2.16.840.1.113730.3.4.10": {
                return VirtualListViewResponseControl.decodeJSONControl(controlObject, strict);
            }
            case "1.3.6.1.4.1.36733.2.1.5.7": {
                return W3CTraceContextRequestControl.decodeJSONControl(controlObject, strict);
            }
        }
        JSONControlDecodeHelper jsonControl = new JSONControlDecodeHelper(controlObject, strict, true, false);
        if (jsonControl.getValueObject() != null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, LDAPMessages.ERR_CONTROL_JSON_UNABLE_TO_SUPPORT_VALUE_JSON.get(controlObject.toSingleLineString(), "value-json", oid, "value-base64"));
        }
        return new Control(jsonControl.getOID(), jsonControl.getCriticality(), jsonControl.getRawValue());
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("Control(oid=");
        buffer.append(this.oid);
        buffer.append(", isCritical=");
        buffer.append(this.isCritical);
        buffer.append(", value=");
        if (this.value == null) {
            buffer.append("{null}");
        } else {
            buffer.append("{byte[");
            buffer.append(this.value.getValue().length);
            buffer.append("]}");
        }
        buffer.append(')');
    }

    static {
        com.unboundid.ldap.sdk.controls.ControlHelper.registerDefaultResponseControls();
        ControlHelper.registerDefaultResponseControls();
        com.unboundid.ldap.sdk.forgerockds.controls.ControlHelper.registerDefaultResponseControls();
        com.unboundid.ldap.sdk.unboundidds.controls.ControlHelper.registerDefaultResponseControls();
    }
}

