/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.tez.runtime.api.impl.TezEvent;

public class TezHeartbeatResponse
implements Writable {
    private long lastRequestId;
    private boolean shouldDie = false;
    private List<TezEvent> events;
    private int nextFromEventId;
    private int nextPreRoutedEventId;

    public TezHeartbeatResponse() {
    }

    public TezHeartbeatResponse(List<TezEvent> events) {
        this.events = Collections.unmodifiableList(events);
    }

    public List<TezEvent> getEvents() {
        return this.events;
    }

    public boolean shouldDie() {
        return this.shouldDie;
    }

    public long getLastRequestId() {
        return this.lastRequestId;
    }

    public int getNextFromEventId() {
        return this.nextFromEventId;
    }

    public int getNextPreRoutedEventId() {
        return this.nextPreRoutedEventId;
    }

    public void setEvents(List<TezEvent> events) {
        this.events = Collections.unmodifiableList(events);
    }

    public void setLastRequestId(long lastRequestId) {
        this.lastRequestId = lastRequestId;
    }

    public void setShouldDie() {
        this.shouldDie = true;
    }

    public void setNextFromEventId(int nextFromEventId) {
        this.nextFromEventId = nextFromEventId;
    }

    public void setNextPreRoutedEventId(int nextPreRoutedEventId) {
        this.nextPreRoutedEventId = nextPreRoutedEventId;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.lastRequestId);
        out.writeBoolean(this.shouldDie);
        out.writeInt(this.nextFromEventId);
        out.writeInt(this.nextPreRoutedEventId);
        if (this.events != null) {
            out.writeBoolean(true);
            out.writeInt(this.events.size());
            for (TezEvent e : this.events) {
                e.write(out);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.lastRequestId = in.readLong();
        this.shouldDie = in.readBoolean();
        this.nextFromEventId = in.readInt();
        this.nextPreRoutedEventId = in.readInt();
        if (in.readBoolean()) {
            int eventCount = in.readInt();
            this.events = new ArrayList<TezEvent>(eventCount);
            for (int i = 0; i < eventCount; ++i) {
                TezEvent e = new TezEvent();
                e.readFields(in);
                this.events.add(e);
            }
        }
    }

    public String toString() {
        return "{  lastRequestId=" + this.lastRequestId + ", shouldDie=" + this.shouldDie + ", nextFromEventId=" + this.nextFromEventId + ", nextPreRoutedEventId=" + this.nextPreRoutedEventId + ", eventCount=" + (this.events != null ? this.events.size() : 0) + " }";
    }
}

