/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.tomee.loader.TomEEJarScanner;

public class TomcatHelper {
    private static StandardServer server;
    private static boolean stopping;

    public static boolean isStopping() {
        return stopping;
    }

    public static void setServer(StandardServer server) {
        TomcatHelper.server = server;
        SystemInstance.get().setComponent(Server.class, (Object)server);
    }

    public static void setStopping(boolean stopping) {
        TomcatHelper.stopping = stopping;
    }

    public static StandardServer getServer() {
        StandardServer server = null;
        try {
            Class<?> systemInstanceClass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.openejb.loader.SystemInstance");
            Object instance = systemInstanceClass.getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
            server = (StandardServer)systemInstanceClass.getDeclaredMethod("getComponent", Class.class).invoke(instance, StandardServer.class);
        }
        catch (Exception systemInstanceClass) {
            // empty catch block
        }
        if (server != null) {
            TomcatHelper.server = server;
            return server;
        }
        try {
            Class<?> tomcatServerFactory = Class.forName("org.apache.catalina.ServerFactory");
            Method getServerMethod = tomcatServerFactory.getMethod("getServer", new Class[0]);
            server = (StandardServer)getServerMethod.invoke(null, new Object[0]);
        }
        catch (Exception tomcatServerFactory) {
            // empty catch block
        }
        if (server != null) {
            TomcatHelper.server = server;
            return server;
        }
        if (TomcatHelper.server != null) {
            return TomcatHelper.server;
        }
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            server = (StandardServer)mbeanServer.getAttribute(new ObjectName("Catalina:type=Server"), "managedResource");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (server != null) {
            TomcatHelper.server = server;
            return server;
        }
        return TomcatHelper.server;
    }

    public static int getContextState(StandardContext standardContext) {
        try {
            Method getStateMethod = StandardContext.class.getMethod("getState", new Class[0]);
            Object result = getStateMethod.invoke((Object)standardContext, new Object[0]);
            if (Integer.TYPE.equals(result.getClass())) {
                int state = (Integer)result;
                return state;
            }
            if (result.getClass().isEnum()) {
                Enum e = (Enum)result;
                if ("FAILED".equals(e.toString())) {
                    return 4;
                }
                if ("STOPPING".equals(e.toString()) || "STOPPING_PREP".equals(e.toString()) || "MUST_STOP".equals(e.toString()) || "MUST_DESTROY".equals(e.toString())) {
                    return 2;
                }
                if ("RUNNING".equals(e.toString()) || "STARTED".equals(e.toString())) {
                    return 1;
                }
                if ("INITIALIZED".equals(e.toString())) {
                    return 0;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 3;
    }

    public static boolean hasRole(Realm realm, Principal tomcatPrincipal, String logicalRole) {
        try {
            Method method = realm.getClass().getMethod("hasRole", Wrapper.class, Principal.class, String.class);
            return (Boolean)method.invoke((Object)realm, null, tomcatPrincipal, logicalRole);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isTomcat7() {
        return System.getProperty("tomcat.version", "7.").startsWith("7.");
    }

    public static void configureJarScanner(Context standardContext) {
        try {
            JarScanner originalJarScanner = standardContext.getJarScanner();
            if ("true".equalsIgnoreCase(SystemInstance.get().getProperty("tomee.tomcat.override.jar-scanner", "true")) && !TomEEJarScanner.class.isInstance(originalJarScanner) && StandardJarScanner.class.isInstance(originalJarScanner)) {
                JarScanFilter jarScanFilter;
                String scanBootstrap;
                TomEEJarScanner jarScanner = new TomEEJarScanner();
                Properties properties = SystemInstance.get().getProperties();
                String scanClasspath = properties.getProperty(TomEEJarScanner.class.getName() + ".scanClassPath");
                if (scanClasspath != null) {
                    jarScanner.setScanClassPath(Boolean.parseBoolean(scanClasspath));
                }
                if ((scanBootstrap = properties.getProperty(TomEEJarScanner.class.getName() + ".scanBootstrapClassPath")) != null) {
                    jarScanner.setScanBootstrapClassPath(Boolean.parseBoolean(scanBootstrap));
                }
                if ((jarScanFilter = originalJarScanner.getJarScanFilter()) != null && Boolean.parseBoolean(properties.getProperty(TomEEJarScanner.class.getName() + ".useOriginalJarScannerFilter", "true"))) {
                    jarScanner.setJarScanFilter(jarScanFilter);
                }
                standardContext.setJarScanner((JarScanner)jarScanner);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

