/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.descriptor;

import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.CascadableDescriptor;
import jakarta.validation.metadata.ContainerDescriptor;
import jakarta.validation.metadata.ElementDescriptor;
import jakarta.validation.metadata.ExecutableDescriptor;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bval.jsr.ApacheValidatorFactory;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.MetadataReader;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.CompositeBuilder;
import org.apache.bval.jsr.metadata.DualBuilder;
import org.apache.bval.jsr.metadata.HierarchyBuilder;
import org.apache.bval.jsr.metadata.MetadataBuilder;
import org.apache.bval.jsr.metadata.ReflectionBuilder;
import org.apache.bval.util.Validate;

public class DescriptorManager {
    private final ApacheValidatorFactory validatorFactory;
    private final ConcurrentMap<Class<?>, BeanD<?>> beanDescriptors = new ConcurrentHashMap();
    private final ReflectionBuilder reflectionBuilder;

    public static <D extends ElementDescriptor & CascadableDescriptor> boolean isConstrained(D descriptor) {
        return descriptor != null && (descriptor.hasConstraints() || ((CascadableDescriptor)descriptor).isCascaded() || !((ContainerDescriptor)descriptor).getConstrainedContainerElementTypes().isEmpty());
    }

    public static <D extends ElementDescriptor & CascadableDescriptor> boolean isCascaded(D descriptor) {
        return descriptor != null && (((CascadableDescriptor)descriptor).isCascaded() || ((ContainerDescriptor)descriptor).getConstrainedContainerElementTypes().stream().anyMatch(DescriptorManager::isCascaded));
    }

    public static <E extends ExecutableDescriptor> boolean isConstrained(E descriptor) {
        return descriptor != null && (descriptor.hasConstrainedParameters() || descriptor.hasConstrainedReturnValue());
    }

    public DescriptorManager(ApacheValidatorFactory validatorFactory) {
        this.validatorFactory = Validate.notNull(validatorFactory, "validatorFactory", new Object[0]);
        this.reflectionBuilder = new ReflectionBuilder(validatorFactory);
    }

    public <T> BeanDescriptor getBeanDescriptor(Class<T> beanClass) {
        Validate.notNull(beanClass, IllegalArgumentException::new, "beanClass", new Object[0]);
        BeanD existing = (BeanD)this.beanDescriptors.get(beanClass);
        if (existing != null) {
            return existing;
        }
        BeanD<T> value = new BeanD<T>(new MetadataReader(this.validatorFactory, beanClass).forBean(this.builder(beanClass)));
        BeanD<T> previous = this.beanDescriptors.putIfAbsent(beanClass, value);
        return previous == null ? value : previous;
    }

    public void clear() {
        this.beanDescriptors.clear();
    }

    private <T> MetadataBuilder.ForBean<T> builder(Class<T> beanClass) {
        MetadataBuilder.ForBean<T> primaryBuilder = new HierarchyBuilder(this.validatorFactory, this.reflectionBuilder::forBean).forBean(beanClass);
        MetadataBuilder.ForBean<T> customBuilder = new HierarchyBuilder(this.validatorFactory, this::customBuilder).forBean(beanClass);
        return customBuilder.isEmpty() ? primaryBuilder : DualBuilder.forBean(beanClass, primaryBuilder, customBuilder, this.validatorFactory);
    }

    private <T> MetadataBuilder.ForBean<T> customBuilder(Class<T> beanClass) {
        List<MetadataBuilder.ForBean<T>> customBuilders = this.validatorFactory.getMetadataBuilders().getCustomBuilders(beanClass);
        if (customBuilders.isEmpty()) {
            return null;
        }
        if (customBuilders.size() == 1) {
            return customBuilders.get(0);
        }
        return customBuilders.stream().collect(CompositeBuilder.with(this.validatorFactory, AnnotationBehaviorMergeStrategy.consensus()).compose());
    }
}

