/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.attachment.AttachmentDeserializerUtil;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public class AttachmentBoundaryDeserializer {
    private static final Pattern INPUT_STREAM_BOUNDARY_PATTERN = Pattern.compile("^--(\\S*)$", 8);
    private static final int PUSHBACK_AMOUNT = 2048;
    private final int maxHeaderLength;
    private final Message message;

    public AttachmentBoundaryDeserializer(Message message) {
        this.message = message;
        this.maxHeaderLength = MessageUtils.getContextualInteger(message, "attachment-max-header-size", AttachmentDeserializer.DEFAULT_MAX_HEADER_SIZE);
    }

    public Attachment read(InputStream body) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(body, 2048);
        String boundaryString = this.findBoundaryFromInputStream(stream);
        if (null == boundaryString) {
            throw new IOException("Couldn't determine the boundary from the message!");
        }
        byte[] boundary = boundaryString.getBytes(StandardCharsets.UTF_8);
        if (!AttachmentDeserializerUtil.readTillFirstBoundary(stream, boundary)) {
            throw new IOException("Couldn't find MIME boundary: " + boundaryString);
        }
        MimeBodyPartInputStream mmps = new MimeBodyPartInputStream(stream, boundary, 2048);
        Map<String, List<String>> ih = AttachmentDeserializerUtil.loadPartHeaders(stream, this.maxHeaderLength);
        String val = AttachmentUtil.getHeader(ih, "Content-Transfer-Encoding");
        InputStream ins = AttachmentUtil.decode(mmps, val);
        if (ins != mmps) {
            ih.remove("Content-Transfer-Encoding");
        }
        return AttachmentUtil.createAttachment(new DelegatingInputStream(ins, is -> stream.close()), ih, this.message);
    }

    private String findBoundaryFromInputStream(PushbackInputStream stream) throws IOException {
        int i;
        byte[] buf = new byte[2048];
        int len = i = stream.read(buf);
        while (i > 0 && len < buf.length) {
            i = stream.read(buf, len, buf.length - len);
            if (i <= 0) continue;
            len += i;
        }
        String msg = IOUtils.newStringFromBytes(buf, 0, len);
        stream.unread(buf, 0, len);
        Matcher m = INPUT_STREAM_BOUNDARY_PATTERN.matcher(msg);
        return m.find() ? "--" + m.group(1) : null;
    }
}

