/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.impl;

import java.security.Key;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.LazySet;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Resolver;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.AlgorithmPolicyConfiguration;
import org.opensaml.xmlsec.AlgorithmPolicyParameters;
import org.opensaml.xmlsec.impl.ExcludedAlgorithmsPredicate;
import org.opensaml.xmlsec.impl.IncludedAlgorithmsPredicate;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.slf4j.Logger;

public abstract class AbstractSecurityParametersResolver<ProductType>
implements Resolver<ProductType, CriteriaSet> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractSecurityParametersResolver.class);

    @Nullable
    protected KeyInfoGenerator lookupKeyInfoGenerator(@Nonnull Credential credential, @Nullable NamedKeyInfoGeneratorManager manager, @Nullable String keyInfoProfileName) {
        Constraint.isNotNull((Object)credential, (String)"Credential may not be null");
        if (manager == null) {
            this.log.trace("NamedKeyInfoGeneratorManger was null, can not resolve");
            return null;
        }
        if (this.log.isTraceEnabled()) {
            Key key = CredentialSupport.extractSigningKey((Credential)credential);
            if (key == null) {
                key = CredentialSupport.extractEncryptionKey((Credential)credential);
            }
            this.log.trace("Attempting to resolve KeyInfoGenerator for credential with key algo '{}' of impl: {}", (Object)(key != null ? key.getAlgorithm() : "n/a"), (Object)credential.getClass().getName());
        }
        return KeyInfoSupport.getKeyInfoGenerator((Credential)credential, (NamedKeyInfoGeneratorManager)manager, (String)keyInfoProfileName);
    }

    protected void resolveAndPopulateIncludesExcludes(@Nonnull AlgorithmPolicyParameters params, @Nonnull CriteriaSet criteria, @Nonnull @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        Collection<String> includes = this.resolveEffectiveIncludes(criteria, configs);
        this.log.trace("Resolved effective includes: {}", includes);
        Collection<String> excludes = this.resolveEffectiveExcludes(criteria, configs);
        this.log.trace("Resolved effective excludes: {}", excludes);
        if (includes.isEmpty() && excludes.isEmpty()) {
            this.log.trace("Both empty, nothing to populate");
            return;
        }
        if (includes.isEmpty()) {
            this.log.trace("Includes empty, populating excludes");
            params.setExcludedAlgorithms(excludes);
            return;
        }
        if (excludes.isEmpty()) {
            this.log.trace("Excludes empty, populating includes");
            params.setIncludedAlgorithms(includes);
            return;
        }
        AlgorithmPolicyConfiguration.Precedence precedence = this.resolveIncludeExcludePrecedence(criteria, configs);
        this.log.trace("Resolved effective precedence: {}", (Object)precedence);
        switch (precedence) {
            case INCLUDE: {
                this.log.trace("Based on precedence, populating includes");
                params.setIncludedAlgorithms(includes);
                break;
            }
            case EXCLUDE: {
                this.log.trace("Based on precedence, populating excludes");
                params.setExcludedAlgorithms(excludes);
                break;
            }
            default: {
                throw new IllegalArgumentException("Include/Exclude Precedence value is unknown: " + String.valueOf(precedence));
            }
        }
    }

    @Nonnull
    protected Predicate<String> resolveIncludeExcludePredicate(@Nonnull CriteriaSet criteria, @Nonnull @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        Collection<String> includes = this.resolveEffectiveIncludes(criteria, configs);
        this.log.trace("Resolved effective includes: {}", includes);
        Collection<String> excludes = this.resolveEffectiveExcludes(criteria, configs);
        this.log.trace("Resolved effective excludes: {}", excludes);
        if (includes.isEmpty() && excludes.isEmpty()) {
            this.log.trace("Both empty, returning alwaysTrue predicate");
            return PredicateSupport.alwaysTrue();
        }
        if (includes.isEmpty()) {
            this.log.trace("Includes empty, returning ExcludedAlgorithmsPredicate");
            return new ExcludedAlgorithmsPredicate(excludes);
        }
        if (excludes.isEmpty()) {
            this.log.trace("Excludes empty, returning IncludedAlgorithmsPredicate");
            return new IncludedAlgorithmsPredicate(includes);
        }
        AlgorithmPolicyConfiguration.Precedence precedence = this.resolveIncludeExcludePrecedence(criteria, configs);
        this.log.trace("Resolved effective precedence: {}", (Object)precedence);
        switch (precedence) {
            case INCLUDE: {
                this.log.trace("Based on precedence, returning IncludedAlgorithmsPredicate");
                return new IncludedAlgorithmsPredicate(includes);
            }
            case EXCLUDE: {
                this.log.trace("Based on precedence, returning ExcludedAlgorithmsPredicate");
                return new ExcludedAlgorithmsPredicate(excludes);
            }
        }
        throw new IllegalArgumentException("Include/Exclude Precedence value is unknown: " + String.valueOf(precedence));
    }

    @Nonnull
    protected Collection<String> resolveEffectiveExcludes(@Nonnull CriteriaSet criteria, @Nonnull @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        LazySet accumulator = new LazySet();
        for (AlgorithmPolicyConfiguration algorithmPolicyConfiguration : configs) {
            accumulator.addAll(algorithmPolicyConfiguration.getExcludedAlgorithms());
            if (algorithmPolicyConfiguration.isExcludeMerge()) continue;
            break;
        }
        return accumulator;
    }

    @Nonnull
    protected Collection<String> resolveEffectiveIncludes(@Nonnull CriteriaSet criteria, @Nonnull @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        LazySet accumulator = new LazySet();
        for (AlgorithmPolicyConfiguration algorithmPolicyConfiguration : configs) {
            accumulator.addAll(algorithmPolicyConfiguration.getIncludedAlgorithms());
            if (algorithmPolicyConfiguration.isIncludeMerge()) continue;
            break;
        }
        return accumulator;
    }

    @Nonnull
    protected AlgorithmPolicyConfiguration.Precedence resolveIncludeExcludePrecedence(@Nonnull CriteriaSet criteria, @Nonnull @NotEmpty List<? extends AlgorithmPolicyConfiguration> configs) {
        return configs.get(0).getIncludeExcludePrecedence();
    }
}

