/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.testing;

import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.testing.Application;
import org.apache.openejb.testing.ApplicationComposers;
import org.apache.openejb.testing.RandomPort;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;

public class SingleApplicationComposerBase {
    private static volatile boolean started = false;
    private static final AtomicReference<Object> APP = new AtomicReference();
    private static final AtomicReference<Thread> HOOK = new AtomicReference();

    public void setApp(Object o) {
        APP.set(o);
    }

    public void close() {
        Thread hook = HOOK.get();
        if (hook != null) {
            hook.run();
            Runtime.getRuntime().removeShutdownHook(hook);
            HOOK.compareAndSet(hook, null);
            APP.set(null);
        }
    }

    public void start(Class<?> marker) throws Exception {
        if (APP.get() == null) {
            Class type;
            String typeStr = JavaSecurityManagers.getSystemProperty("tomee.application-composer.application");
            if (typeStr != null) {
                try {
                    type = Thread.currentThread().getContextClassLoader().loadClass(typeStr);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            } else {
                if (marker == null) {
                    throw new IllegalArgumentException("set tomee.application-composer.application system property or add a marker to the rule or runner");
                }
                Iterator descriptors = new AnnotationFinder((Archive)new FileArchive(Thread.currentThread().getContextClassLoader(), JarLocation.jarLocation(marker)), false).findAnnotatedClasses(Application.class).iterator();
                if (!descriptors.hasNext()) {
                    throw new IllegalArgumentException("No descriptor class using @Application");
                }
                type = (Class)descriptors.next();
                if (descriptors.hasNext()) {
                    throw new IllegalArgumentException("Ambiguous @Application: " + String.valueOf(type) + ", " + String.valueOf(descriptors.next()));
                }
            }
            try {
                APP.compareAndSet(null, type.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
        if (!started) {
            Object app = APP.get();
            ApplicationComposers composers = new ApplicationComposers(app.getClass(), new Object[0]){

                @Override
                public void deployApp(Object inputTestInstance) throws Exception {
                    super.deployApp(inputTestInstance);
                    if (!started) {
                        final ThreadContext previous = ThreadContext.getThreadContext();
                        final 1 comp = this;
                        Thread hook = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    comp.after();
                                }
                                catch (Exception e) {
                                    ThreadContext.exit(previous);
                                    throw new IllegalStateException(e);
                                }
                            }
                        };
                        HOOK.set(hook);
                        Runtime.getRuntime().addShutdownHook(hook);
                        started = true;
                    }
                }
            };
            composers.before(app);
            composers.handleLifecycle(app.getClass(), app);
        }
    }

    public void composerInject(Object target) throws IllegalAccessException {
        WebBeansContext wbc = null;
        try {
            wbc = WebBeansContext.currentInstance();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (wbc != null) {
            OWBInjector.inject((BeanManager)wbc.getBeanManagerImpl(), (Object)target, null);
        }
        Object app = APP.get();
        Class<?> aClass = target.getClass();
        block2: for (Field f : aClass.getDeclaredFields()) {
            if (f.isAnnotationPresent(RandomPort.class)) {
                for (Field field : app.getClass().getDeclaredFields()) {
                    if (field.getType() != f.getType()) continue;
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                    Object value = field.get(app);
                    f.set(target, value);
                    continue block2;
                }
                continue;
            }
            if (!f.isAnnotationPresent(Application.class)) continue;
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            f.set(target, app);
        }
        Class<?> superclass = aClass.getSuperclass();
        if (superclass != Object.class) {
            this.composerInject(superclass);
        }
    }

    public boolean isStarted() {
        return started;
    }
}

