/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.InjectableMethod;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.Asserts;

public abstract class BaseProducerProducer<T, P>
extends AbstractProducer<T> {
    protected Bean<P> owner;
    protected WebBeansContext webBeansContext;
    protected Method disposalMethod;
    protected Set<InjectionPoint> disposalIPs;
    protected boolean isAnyDisposal;
    protected AnnotatedMethod<? super P> disposerMethod;

    public BaseProducerProducer(Bean<P> owner, AnnotatedMethod<? super P> disposerMethod, Set<InjectionPoint> points, Set<InjectionPoint> disposalIPs, WebBeansContext webBeansContext) {
        super(points);
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        this.owner = owner;
        this.webBeansContext = webBeansContext;
        this.disposalIPs = disposalIPs;
        OpenWebBeansEjbPlugin ejbPlugin = webBeansContext.getPluginLoader().getEjbPlugin();
        if (ejbPlugin != null) {
            if (disposerMethod != null) {
                this.disposalMethod = ejbPlugin.resolveViewMethod(owner, disposerMethod.getJavaMember());
            }
        } else if (disposerMethod != null) {
            this.disposalMethod = disposerMethod.getJavaMember();
        }
        if (disposerMethod != null) {
            for (AnnotatedParameter param : disposerMethod.getParameters()) {
                if (!param.isAnnotationPresent(Disposes.class)) continue;
                this.isAnyDisposal = param.isAnnotationPresent(Any.class);
                break;
            }
        }
        this.disposerMethod = disposerMethod;
    }

    public AnnotatedMethod<? super P> getDisposerMethod() {
        return this.disposerMethod;
    }

    @Override
    public void defineInterceptorStack(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        if (webBeansContext.getOpenWebBeansConfiguration().supportsInterceptionOnProducers()) {
            super.defineInterceptorStack(bean, annotatedType, webBeansContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(T instance) {
        if (this.disposalMethod != null) {
            Object parentInstance = null;
            CreationalContext parentCreationalContext = null;
            try {
                parentCreationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.owner);
                if (!Modifier.isStatic(this.disposalMethod.getModifiers())) {
                    parentInstance = this.webBeansContext.getBeanManagerImpl().getReference(this.owner, this.owner.getBeanClass(), parentCreationalContext);
                }
                InjectableMethod m = new InjectableMethod(this.disposalMethod, parentInstance, this, (CreationalContextImpl)parentCreationalContext, this.disposalIPs);
                m.setDisposable(true);
                m.setProducerMethodInstance(instance);
                m.doInjection();
            }
            finally {
                if (parentCreationalContext != null) {
                    parentCreationalContext.release();
                }
            }
        }
    }

    public Set<InjectionPoint> getDisposalIPs() {
        return this.disposalIPs;
    }

    public boolean isAnyDisposal() {
        return this.isAnyDisposal;
    }
}

