/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.util.EmulatedAnnotatedType;
import org.apache.bval.util.Lazy;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public abstract class Meta<E extends AnnotatedElement> {
    private final E host;
    private final ElementType elementType;

    protected Meta(E host, ElementType elementType) {
        this.host = (AnnotatedElement)Validate.notNull(host, "host", new Object[0]);
        this.elementType = Validate.notNull(elementType, "elementType", new Object[0]);
    }

    public E getHost() {
        return this.host;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public abstract Type getType();

    public abstract Class<?> getDeclaringClass();

    public abstract AnnotatedType getAnnotatedType();

    public abstract String getName();

    public abstract Meta<?> getParent();

    public final String toString() {
        return String.format("%s.%s(%s)", Meta.class.getSimpleName(), this.getClass().getSimpleName(), this.describeHost());
    }

    public String describeHost() {
        return this.host.toString();
    }

    public static class ForContainerElement
    extends Meta<AnnotatedType> {
        private final Meta<?> parent;
        private final ContainerElementKey key;

        public ForContainerElement(Meta<?> parent, ContainerElementKey key) {
            super(key.getAnnotatedType(), ElementType.TYPE_USE);
            this.parent = Validate.notNull(parent, "parent", new Object[0]);
            this.key = Validate.notNull(key, "key", new Object[0]);
        }

        @Override
        public Type getType() {
            Map<TypeVariable<?>, Type> typeArguments;
            Type parentType;
            Type result = ((AnnotatedType)this.getHost()).getType();
            if (result instanceof TypeVariable && (parentType = this.parent.getType()) instanceof ParameterizedType && (typeArguments = TypeUtils.getTypeArguments((ParameterizedType)parentType)).containsKey(result)) {
                return typeArguments.get(result);
            }
            return result;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.parent.getDeclaringClass();
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return this.key.getAnnotatedType();
        }

        public Integer getTypeArgumentIndex() {
            return this.key.getTypeArgumentIndex();
        }

        @Override
        public String getName() {
            return this.key.toString();
        }

        @Override
        public String describeHost() {
            return String.format("%s of %s", this.key, this.parent);
        }

        @Override
        public Meta<?> getParent() {
            return this.parent;
        }
    }

    public static class ForParameter
    extends Meta<Parameter> {
        private final String name;
        private final Lazy<Meta<? extends Executable>> parent = new Lazy<Meta>(this::computeParent);

        public ForParameter(Parameter host, String name) {
            super(host, ElementType.PARAMETER);
            this.name = Validate.notNull(name, "name", new Object[0]);
        }

        @Override
        public Type getType() {
            return ((Parameter)this.getHost()).getParameterizedType();
        }

        @Override
        public Class<?> getDeclaringClass() {
            return ((Parameter)this.getHost()).getDeclaringExecutable().getDeclaringClass();
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return ((Parameter)this.getHost()).getAnnotatedType();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String describeHost() {
            return String.format("%s of %s", this.getName(), ((Parameter)this.getHost()).getDeclaringExecutable());
        }

        @Override
        public Meta<? extends Executable> getParent() {
            return this.parent.get();
        }

        private Meta<? extends Executable> computeParent() {
            Executable exe = ((Parameter)this.getHost()).getDeclaringExecutable();
            return exe instanceof Method ? new ForMethod((Method)exe) : new ForConstructor((Constructor)exe);
        }
    }

    public static class ForCrossParameter<E extends Executable>
    extends Meta<E> {
        private final Meta<E> parent;

        public ForCrossParameter(Meta<E> parent) {
            super((Executable)parent.getHost(), parent.getElementType());
            this.parent = parent;
        }

        @Override
        public Type getType() {
            return Object[].class;
        }

        @Override
        public String getName() {
            return "<cross parameter>";
        }

        @Override
        public String describeHost() {
            return String.format("%s of %s", this.getName(), this.getHost());
        }

        @Override
        public Meta<E> getParent() {
            return this.parent;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return ((Executable)this.getHost()).getDeclaringClass();
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return ((Executable)this.getHost()).getAnnotatedReturnType();
        }
    }

    public static class ForMethod
    extends ForExecutable<Method> {
        public ForMethod(Method host) {
            super(host, ElementType.METHOD);
        }

        @Override
        public Type getType() {
            return ((Method)this.getHost()).getGenericReturnType();
        }

        @Override
        public String getName() {
            return ((Method)this.getHost()).getName();
        }
    }

    public static class ForConstructor<T>
    extends ForExecutable<Constructor<? extends T>> {
        public ForConstructor(Constructor<? extends T> host) {
            super(host, ElementType.CONSTRUCTOR);
        }

        @Override
        public Type getType() {
            return ((Constructor)this.getHost()).getDeclaringClass();
        }

        @Override
        public String getName() {
            return ((Constructor)this.getHost()).getDeclaringClass().getSimpleName();
        }
    }

    public static abstract class ForExecutable<E extends Executable>
    extends ForMember<E> {
        protected ForExecutable(E host, ElementType elementType) {
            super(host, elementType);
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return ((Executable)this.getHost()).getAnnotatedReturnType();
        }
    }

    public static class ForField
    extends ForMember<Field> {
        public ForField(Field host) {
            super(host, ElementType.FIELD);
        }

        @Override
        public Type getType() {
            return ((Field)this.getHost()).getGenericType();
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return ((Field)this.getHost()).getAnnotatedType();
        }

        @Override
        public String getName() {
            return ((Field)this.getHost()).getName();
        }
    }

    public static abstract class ForMember<M extends Member & AnnotatedElement>
    extends Meta<M> {
        private final Lazy<Meta<Class<?>>> parent = new Lazy<Meta>(() -> new ForClass(this.getDeclaringClass()));

        protected ForMember(M host, ElementType elementType) {
            super(host, elementType);
        }

        @Override
        public Class<?> getDeclaringClass() {
            return ((Member)this.getHost()).getDeclaringClass();
        }

        @Override
        public Meta<Class<?>> getParent() {
            return this.parent.get();
        }
    }

    public static class ForClass<T>
    extends Meta<Class<T>> {
        private final AnnotatedType annotatedType;

        public ForClass(Class<T> host) {
            super(host, ElementType.TYPE);
            this.annotatedType = EmulatedAnnotatedType.wrap(host);
        }

        @Override
        public final Class<T> getDeclaringClass() {
            return (Class)this.getHost();
        }

        @Override
        public Type getType() {
            return (Type)this.getHost();
        }

        @Override
        public AnnotatedType getAnnotatedType() {
            return this.annotatedType;
        }

        @Override
        public String getName() {
            return ((Class)this.getHost()).getName();
        }

        @Override
        public Meta<?> getParent() {
            return null;
        }
    }
}

