/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import net.shibboleth.shared.scripting.AbstractScriptEvaluator;
import net.shibboleth.shared.scripting.EvaluableScript;
import org.slf4j.Logger;

public class ScriptedFunction<T, U>
extends AbstractScriptEvaluator
implements Function<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedFunction.class);
    @Nullable
    private Class<T> inputTypeClass;

    protected ScriptedFunction(@Nonnull @NotEmpty EvaluableScript theScript, @Nullable @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted Function from " + extraInfo + ":");
    }

    protected ScriptedFunction(@Nonnull @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous Function:");
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    public U apply(@Nullable T input) {
        Class<T> itype = this.getInputType();
        if (null != itype && null != input && !itype.isInstance(input)) {
            this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), input.getClass(), itype});
            return (U)this.getReturnOnError();
        }
        return (U)this.evaluate(input);
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input", input != null ? input[0] : null, 100);
    }

    @Nonnull
    public static <T, U> ScriptedFunction<T, U> resourceScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initialize();
            ScriptedFunction<T, U> scriptedFunction = new ScriptedFunction<T, U>(script, resource.getDescription());
            return scriptedFunction;
        }
    }

    @Nonnull
    public static <T, U> ScriptedFunction<T, U> resourceScript(@Nonnull @ParameterName(name="resource") Resource resource) throws ScriptException, IOException, ComponentInitializationException {
        return ScriptedFunction.resourceScript("JavaScript", resource);
    }

    @Nonnull
    public static <T, U> ScriptedFunction<T, U> inlineScript(@Nonnull @ParameterName(name="engineName") @NotEmpty String engineName, @Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedFunction<T, U>(script, "Inline");
    }

    @Nonnull
    public static <T, U> ScriptedFunction<T, U> inlineScript(@Nonnull @ParameterName(name="scriptSource") @NotEmpty String scriptSource) throws ScriptException, ComponentInitializationException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initialize();
        return new ScriptedFunction<T, U>(script, "Inline");
    }
}

