/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http;

import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.annotation.JsonbTransient;
import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SavedRequest
implements Serializable {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.TOMEE_SECURITY, SavedRequest.class);
    private static final CookieDeSerializer COOKIE_DE_SERIALIZER = new CookieDeSerializer();
    private static final JsonbConfig jsonbConfig = new JsonbConfig().withSerializers(new JsonbSerializer[]{COOKIE_DE_SERIALIZER}).withDeserializers(new JsonbDeserializer[]{COOKIE_DE_SERIALIZER});
    private Cookie[] cookies;
    private Map<String, List<String>> headers;
    private String method;
    private String url;
    private String queryString;

    public static SavedRequest fromRequest(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headers.put(name, Collections.list(request.getHeaders(name)));
        }
        String method = request.getMethod();
        String queryString = request.getQueryString();
        SavedRequest result = new SavedRequest();
        result.setCookies(cookies);
        result.setHeaders(headers);
        result.setMethod(method);
        result.setUrl(request.getRequestURL().toString());
        result.setQueryString(queryString);
        return result;
    }

    public static SavedRequest fromJson(String json) {
        SavedRequest savedRequest;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfig);
            try {
                savedRequest = (SavedRequest)jsonb.fromJson(json, SavedRequest.class);
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Could not restore request from JSON", (Throwable)e);
                    return null;
                }
            }
            jsonb.close();
        }
        return savedRequest;
    }

    public HttpServletRequest mask(HttpServletRequest masked) {
        return new HttpServletRequestWrapper(masked){

            public Cookie[] getCookies() {
                return SavedRequest.this.cookies;
            }

            public Enumeration<String> getHeaderNames() {
                return SavedRequest.this.headers != null ? Collections.enumeration(SavedRequest.this.headers.keySet()) : Collections.emptyEnumeration();
            }

            public Enumeration<String> getHeaders(String name) {
                List<String> header;
                List<String> list = header = SavedRequest.this.headers != null ? SavedRequest.this.headers.get(name) : null;
                if (header == null) {
                    header = Collections.emptyList();
                }
                return Collections.enumeration(header);
            }

            public String getHeader(String name) {
                List<String> header;
                List<String> list = header = SavedRequest.this.headers != null ? SavedRequest.this.headers.get(name) : null;
                if (header == null || header.isEmpty()) {
                    return null;
                }
                return header.get(0);
            }

            public String getMethod() {
                return SavedRequest.this.method;
            }

            public StringBuffer getRequestURL() {
                return new StringBuffer(SavedRequest.this.url);
            }

            public String getQueryString() {
                return SavedRequest.this.queryString;
            }
        };
    }

    public String toJson() {
        String string;
        block8: {
            Jsonb jsonb = JsonbBuilder.create((JsonbConfig)jsonbConfig);
            try {
                string = jsonb.toJson((Object)this);
                if (jsonb == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonb != null) {
                        try {
                            jsonb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Could not store request in JSON", (Throwable)e);
                    return null;
                }
            }
            jsonb.close();
        }
        return string;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @JsonbTransient
    public String getUrlWithQueryString() {
        return this.queryString == null ? this.url : this.url + "?" + this.queryString;
    }

    public static class CookieDeSerializer
    implements JsonbSerializer<Cookie>,
    JsonbDeserializer<Cookie> {
        public Cookie deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
            String name = null;
            String value = null;
            Map attributes = null;
            while (parser.hasNext()) {
                JsonParser.Event current = parser.next();
                if (current != JsonParser.Event.KEY_NAME) continue;
                String key = parser.getString();
                parser.next();
                if ("name".equals(key)) {
                    name = parser.getString();
                    continue;
                }
                if ("value".equals(key)) {
                    value = parser.getString();
                    continue;
                }
                if (!"attributes".equals(key)) continue;
                attributes = (Map)ctx.deserialize(Map.class, parser);
            }
            Cookie cookie = new Cookie(name, value);
            if (attributes != null) {
                for (Map.Entry entry : attributes.entrySet()) {
                    cookie.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            }
            return cookie;
        }

        public void serialize(Cookie obj, JsonGenerator generator, SerializationContext ctx) {
            generator.write("name", obj.getName());
            generator.write("value", obj.getValue());
            ctx.serialize("attributes", (Object)obj.getAttributes(), generator);
        }
    }
}

