/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import jakarta.ejb.TransactionAttributeType;

public enum TransactionType {
    Mandatory,
    Never,
    NotSupported,
    Required,
    RequiresNew,
    Supports,
    BeanManaged;


    public static TransactionType get(TransactionAttributeType type) {
        switch (type) {
            case REQUIRED: {
                return Required;
            }
            case REQUIRES_NEW: {
                return RequiresNew;
            }
            case MANDATORY: {
                return Mandatory;
            }
            case NEVER: {
                return Never;
            }
            case NOT_SUPPORTED: {
                return NotSupported;
            }
            case SUPPORTS: {
                return Supports;
            }
        }
        throw new IllegalArgumentException("Uknown TransactionAttributeType." + type);
    }

    public static TransactionType get(String name) {
        for (TransactionType type : TransactionType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Uknown TransactionType " + name);
    }
}

