/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.time.Instant;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class FileResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private final org.apache.wicket.util.file.File file;
    private transient InputStream inputStream;

    public FileResourceStream(org.apache.wicket.util.file.File file) {
        Args.notNull(file, "file");
        this.file = file;
    }

    public FileResourceStream(File file) {
        this.file = new org.apache.wicket.util.file.File(file);
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    @Override
    public String getContentType() {
        String contentType = null;
        if (this.file != null) {
            contentType = URLConnection.getFileNameMap().getContentTypeFor(this.file.getName());
        }
        return contentType;
    }

    public org.apache.wicket.util.file.File getFile() {
        return this.file;
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            try {
                this.inputStream = new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new ResourceStreamNotFoundException("Resource " + String.valueOf(this.file) + " could not be found", e);
            }
        }
        return this.inputStream;
    }

    @Override
    public Instant lastModifiedTime() {
        if (this.file != null) {
            return this.file.lastModifiedTime();
        }
        return null;
    }

    public String toString() {
        if (this.file != null) {
            return this.file.toString();
        }
        return "";
    }

    @Override
    public Bytes length() {
        if (this.file != null) {
            return Bytes.bytes(this.file.length());
        }
        return null;
    }

    @Override
    public String locationAsString() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }
}

