/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ComponentEvent;
import org.apache.wicket.IEventDispatcher;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.event.IEventSource;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.apache.wicket.util.visit.Visits;

final class ComponentEventSender
implements IEventSource {
    private final Component source;
    private final IEventDispatcher dispatcher;

    public ComponentEventSender(Component source, IEventDispatcher dispatcher) {
        Args.notNull(source, "source");
        Args.notNull(dispatcher, "dispatcher");
        this.source = source;
        this.dispatcher = dispatcher;
    }

    @Override
    public <T> void send(IEventSink sink, Broadcast type, T payload) {
        ComponentEvent<T> event = new ComponentEvent<T>(sink, this.source, type, payload);
        Args.notNull(type, "type");
        switch (type) {
            case BUBBLE: {
                this.bubble(event);
                break;
            }
            case BREADTH: {
                this.breadth(event);
                break;
            }
            case DEPTH: {
                this.depth(event);
                break;
            }
            case EXACT: {
                this.exact(event);
            }
        }
    }

    private void exact(ComponentEvent<?> event) {
        IEventSink sink = event.getSink();
        if (sink instanceof Component) {
            ComponentEventSender.dispatchToComponent(this.dispatcher, (Component)sink, event);
        } else {
            this.dispatcher.dispatchEvent(sink, event, null);
        }
    }

    private void breadth(ComponentEvent<?> event) {
        IEventSink sink = event.getSink();
        boolean targetsApplication = sink instanceof Application;
        boolean targetsSession = targetsApplication || sink instanceof Session;
        boolean targetsCycle = targetsSession || sink instanceof RequestCycle;
        boolean targetsComponent = sink instanceof Component;
        if (!targetsComponent && !targetsCycle) {
            this.dispatcher.dispatchEvent(sink, event, null);
            return;
        }
        if (targetsApplication) {
            this.dispatcher.dispatchEvent(this.source.getApplication(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsSession) {
            this.dispatcher.dispatchEvent(this.source.getSession(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsCycle) {
            this.dispatcher.dispatchEvent(this.source.getRequestCycle(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        Component cursor = targetsCycle ? this.source.getPage() : (Component)sink;
        ComponentEventSender.dispatchToComponent(this.dispatcher, cursor, event);
        if (event.isStop()) {
            return;
        }
        event.resetShallow();
        if (cursor instanceof MarkupContainer) {
            ((MarkupContainer)cursor).visitChildren(new ComponentEventVisitor<Component>(event, this.dispatcher));
        }
    }

    private void depth(ComponentEvent<?> event) {
        Component cursor;
        IEventSink sink = event.getSink();
        boolean targetsApplication = sink instanceof Application;
        boolean targetsSession = targetsApplication || sink instanceof Session;
        boolean targetsCycle = targetsSession || sink instanceof RequestCycle;
        boolean targetsComponent = sink instanceof Component;
        if (!targetsComponent && !targetsCycle) {
            this.dispatcher.dispatchEvent(sink, event, null);
            return;
        }
        Component component = cursor = targetsCycle ? this.source.getPage() : (Component)sink;
        if (cursor instanceof MarkupContainer) {
            Visits.visitPostOrder(cursor, new ComponentEventVisitor(event, this.dispatcher));
        } else {
            ComponentEventSender.dispatchToComponent(this.dispatcher, cursor, event);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsCycle) {
            this.dispatcher.dispatchEvent(this.source.getRequestCycle(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsSession) {
            this.dispatcher.dispatchEvent(this.source.getSession(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsApplication) {
            this.dispatcher.dispatchEvent(this.source.getApplication(), event, null);
        }
    }

    private void bubble(ComponentEvent<?> event) {
        boolean targetsApplication;
        IEventSink sink = event.getSink();
        boolean targetsComponent = sink instanceof Component;
        boolean targetsCycle = targetsComponent || sink instanceof RequestCycle;
        boolean targetsSession = targetsCycle || sink instanceof Session;
        boolean bl = targetsApplication = targetsSession || sink instanceof Application;
        if (!targetsApplication && !targetsComponent) {
            this.dispatcher.dispatchEvent(sink, event, null);
            return;
        }
        if (targetsComponent) {
            Component cursor = (Component)sink;
            ComponentEventSender.dispatchToComponent(this.dispatcher, cursor, event);
            if (event.isStop()) {
                return;
            }
            cursor.visitParents(MarkupContainer.class, new ComponentEventVisitor(event, this.dispatcher));
        }
        if (event.isStop()) {
            return;
        }
        if (targetsCycle) {
            this.dispatcher.dispatchEvent(this.source.getRequestCycle(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsSession) {
            this.dispatcher.dispatchEvent(this.source.getSession(), event, null);
        }
        if (event.isStop()) {
            return;
        }
        if (targetsApplication) {
            this.dispatcher.dispatchEvent(this.source.getApplication(), event, null);
        }
    }

    private static void dispatchToComponent(IEventDispatcher dispatcher, Component object, ComponentEvent<?> e) {
        dispatcher.dispatchEvent(object, e, null);
        if (e.isStop()) {
            return;
        }
        List<? extends Behavior> behaviors = object.getBehaviors();
        for (Behavior behavior : behaviors) {
            dispatcher.dispatchEvent(behavior, e, object);
            if (!e.isStop()) continue;
            break;
        }
    }

    private static class ComponentEventVisitor<T extends Component>
    implements IVisitor<T, Void> {
        private final ComponentEvent<?> e;
        private final IEventDispatcher dispatcher;

        private ComponentEventVisitor(ComponentEvent<?> event, IEventDispatcher dispatcher) {
            this.e = event;
            this.dispatcher = dispatcher;
        }

        @Override
        public void component(T object, IVisit<Void> visit) {
            ComponentEventSender.dispatchToComponent(this.dispatcher, object, this.e);
            if (this.e.isStop()) {
                visit.stop();
            }
            if (this.e.isShallow()) {
                visit.dontGoDeeper();
            }
            this.e.resetShallow();
        }
    }
}

