/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.el.ext;

import com.google.common.base.Throwables;
import com.hubspot.jinjava.el.ext.NamedParameter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractCallableMethod {
    public static final Method EVAL_METHOD;
    private final String name;
    private final LinkedHashMap<String, Object> argNamesWithDefaults;

    public AbstractCallableMethod(String name, LinkedHashMap<String, Object> argNamesWithDefaults) {
        this.name = name;
        this.argNamesWithDefaults = argNamesWithDefaults;
    }

    public Object evaluate(Object ... args) {
        LinkedHashMap<String, Object> argMap = new LinkedHashMap<String, Object>(this.argNamesWithDefaults);
        LinkedHashMap<String, Object> kwargMap = new LinkedHashMap<String, Object>();
        ArrayList<Object> varArgs = new ArrayList<Object>();
        int argPos = 0;
        for (Map.Entry entry : argMap.entrySet()) {
            Object arg;
            if (argPos >= args.length) break;
            if ((arg = args[argPos++]) instanceof NamedParameter) {
                --argPos;
                break;
            }
            entry.setValue(arg);
        }
        for (int i = argPos; i < args.length; ++i) {
            Object object = args[i];
            if (object instanceof NamedParameter) {
                NamedParameter param = (NamedParameter)object;
                if (argMap.containsKey(param.getName())) {
                    argMap.put(param.getName(), param.getValue());
                    continue;
                }
                kwargMap.put(param.getName(), param.getValue());
                continue;
            }
            varArgs.add(object);
        }
        return this.doEvaluate(argMap, kwargMap, varArgs);
    }

    public abstract Object doEvaluate(Map<String, Object> var1, Map<String, Object> var2, List<Object> var3);

    public String getName() {
        return this.name;
    }

    public List<String> getArguments() {
        return new ArrayList<String>(this.argNamesWithDefaults.keySet());
    }

    public Map<String, Object> getDefaults() {
        return this.argNamesWithDefaults;
    }

    static {
        try {
            EVAL_METHOD = AbstractCallableMethod.class.getMethod("evaluate", Object[].class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

