/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.jinjava.lib.filter;

import com.hubspot.jinjava.doc.annotations.JinjavaDoc;
import com.hubspot.jinjava.doc.annotations.JinjavaParam;
import com.hubspot.jinjava.doc.annotations.JinjavaSnippet;
import com.hubspot.jinjava.interpret.InvalidArgumentException;
import com.hubspot.jinjava.interpret.InvalidInputException;
import com.hubspot.jinjava.interpret.InvalidReason;
import com.hubspot.jinjava.interpret.JinjavaInterpreter;
import com.hubspot.jinjava.interpret.TemplateSyntaxException;
import com.hubspot.jinjava.lib.Importable;
import com.hubspot.jinjava.lib.filter.Filter;
import java.math.BigDecimal;
import java.math.BigInteger;

@JinjavaDoc(value="Divides the current value by a divisor", input={@JinjavaParam(value="value", type="number", desc="The numerator to be divided", required=true)}, params={@JinjavaParam(value="divisor", type="number", desc="The divisor to divide the value", required=true)}, snippets={@JinjavaSnippet(code="{% set numerator = 106 %}\n{% numerator|divide(2) %}")})
public class DivideFilter
implements Filter {
    @Override
    public Object filter(Object object, JinjavaInterpreter interpreter, String ... arg) {
        BigDecimal num;
        if (arg.length < 1) {
            throw new TemplateSyntaxException(interpreter, this.getName(), "requires 1 number (divisor) argument");
        }
        String toMul = arg[0];
        if (toMul != null) {
            try {
                num = new BigDecimal(toMul);
            }
            catch (NumberFormatException e) {
                throw new InvalidArgumentException(interpreter, (Importable)this, InvalidReason.NUMBER_FORMAT, 0, toMul);
            }
        } else {
            return object;
        }
        if (object instanceof Integer) {
            return (Integer)object / ((Number)num).intValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue() / ((Number)num).floatValue());
        }
        if (object instanceof Long) {
            return (Long)object / ((Number)num).longValue();
        }
        if (object instanceof Short) {
            return (Short)object / num.shortValue();
        }
        if (object instanceof Double) {
            return (Double)object / ((Number)num).doubleValue();
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).divide(BigDecimal.valueOf(((Number)num).doubleValue()));
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).divide(BigInteger.valueOf(((Number)num).longValue()));
        }
        if (object instanceof Byte) {
            return (Byte)object / num.byteValue();
        }
        if (object instanceof String) {
            try {
                return Double.valueOf((String)object) / ((Number)num).doubleValue();
            }
            catch (NumberFormatException e) {
                throw new InvalidInputException(interpreter, this, InvalidReason.NUMBER_FORMAT, object.toString());
            }
        }
        return object;
    }

    @Override
    public String getName() {
        return "divide";
    }
}

