/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.WinSize;
import com.pty4j.unix.PTYInputStream;
import com.pty4j.unix.PTYOutputStream;
import com.pty4j.unix.PtyHelpers;
import com.pty4j.util.Pair;
import java.io.IOException;
import java.util.Locale;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Termios;

public class Pty {
    private final boolean myConsole;
    private String mySlaveName;
    private PTYInputStream myIn;
    private PTYOutputStream myOut;
    private final Object myFDLock = new Object();
    private final Object mySelectLock = new Object();
    private final int[] myPipe = new int[2];
    private volatile int myMaster;
    private static boolean setTerminalSizeErrorAlreadyLogged;
    private static final boolean useSelect;
    private static final Object PTSNAME_LOCK;

    private static boolean isOSXLessThanOrEqualTo106() {
        String version;
        String[] strings;
        return System.getProperty("os.name").toLowerCase(Locale.US).startsWith("mac") && (strings = (version = System.getProperty("os.version").toLowerCase(Locale.US)).split("\\.")).length > 1 && strings[0].equals("10") && Integer.valueOf(strings[1]) <= 6;
    }

    public Pty() throws IOException {
        this(false);
    }

    public Pty(boolean console) throws IOException {
        this.myConsole = console;
        Pair<Integer, String> masterSlave = this.openMaster(console);
        this.myMaster = (Integer)masterSlave.first;
        this.mySlaveName = (String)masterSlave.second;
        if (this.mySlaveName == null) {
            throw new IOException("Util.exception.cannotCreatePty");
        }
        this.myIn = new PTYInputStream(this);
        this.myOut = new PTYOutputStream(this);
        JTermios.pipe(this.myPipe);
    }

    public String getSlaveName() {
        return this.mySlaveName;
    }

    public int getMasterFD() {
        return this.myMaster;
    }

    public final boolean isConsole() {
        return this.myConsole;
    }

    public PTYOutputStream getOutputStream() {
        return this.myOut;
    }

    public PTYInputStream getInputStream() {
        return this.myIn;
    }

    @Deprecated
    public final void setTerminalSize(int width, int height) {
        this.setTerminalSize(new WinSize(width, height, 0, 0));
    }

    public final void setTerminalSize(WinSize winSize) {
        block3: {
            try {
                int res = Pty.changeWindowSize(this.myMaster, winSize);
                if (res != 0) {
                    throw new IllegalStateException("Can set new window size. ioctl returns " + res + ", errorno=" + JTermios.errno());
                }
            }
            catch (UnsatisfiedLinkError e) {
                if (setTerminalSizeErrorAlreadyLogged) break block3;
                setTerminalSizeErrorAlreadyLogged = true;
            }
        }
    }

    public WinSize getWinSize() throws IOException {
        WinSize result = new WinSize();
        if (PtyHelpers.getWinSize(this.myMaster, result) < 0) {
            throw new IOException("Failed to get window size: " + PtyHelpers.errno());
        }
        return result;
    }

    private Pair<Integer, String> ptyMasterOpen() {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        String name = "/dev/ptmx";
        int fdm = m_jpty.getpt();
        if (fdm < 0) {
            return Pair.create(-1, name);
        }
        if (m_jpty.grantpt(fdm) < 0) {
            m_jpty.close(fdm);
            return Pair.create(-2, name);
        }
        if (m_jpty.unlockpt(fdm) < 0) {
            m_jpty.close(fdm);
            return Pair.create(-3, name);
        }
        String ptr = Pty.ptsname(m_jpty, fdm);
        if (ptr == null) {
            m_jpty.close(fdm);
            return Pair.create(-4, name);
        }
        return Pair.create(fdm, ptr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String ptsname(PtyHelpers.OSFacade m_jpty, int fdm) {
        Object object = PTSNAME_LOCK;
        synchronized (object) {
            return m_jpty.ptsname(fdm);
        }
    }

    public static void setNoEcho(int fd) {
        Termios stermios = new Termios();
        if (JTermios.tcgetattr(fd, stermios) < 0) {
            return;
        }
        stermios.c_lflag &= ~(JTermios.ECHO | JTermios.ECHOE | PtyHelpers.ECHOK | JTermios.ECHONL);
        stermios.c_iflag |= JTermios.IGNCR;
        JTermios.tcsetattr(fd, JTermios.TCSANOW, stermios);
    }

    private Pair<Integer, String> openMaster(boolean console) {
        Pair<Integer, String> master = this.ptyMasterOpen();
        if ((Integer)master.first >= 0 && console) {
            Pty.setNoEcho((Integer)master.first);
        }
        return master;
    }

    @Deprecated
    public static int changeWindowsSize(int fd, int width, int height) {
        return Pty.changeWindowSize(fd, new WinSize(width, height));
    }

    private static int changeWindowSize(int fd, WinSize ws) {
        return PtyHelpers.getInstance().setWinSize(fd, ws);
    }

    public static int raise(int pid, int sig) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int status = m_jpty.killpg(pid, sig);
        if (status == -1) {
            status = m_jpty.kill(pid, sig);
        }
        return status;
    }

    public boolean isClosed() {
        return this.myMaster == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.myMaster != -1) {
            Object object = this.myFDLock;
            synchronized (object) {
                if (this.myMaster != -1) {
                    try {
                        int status = this.close0(this.myMaster);
                        if (status == -1) {
                            throw new IOException("Close error");
                        }
                    }
                    finally {
                        this.myMaster = -1;
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int close0(int fd) throws IOException {
        int ret = JTermios.close(fd);
        this.breakRead();
        Object object = this.mySelectLock;
        synchronized (object) {
            JTermios.close(this.myPipe[0]);
            JTermios.close(this.myPipe[1]);
            this.myPipe[0] = -1;
            this.myPipe[1] = -1;
        }
        return ret;
    }

    void breakRead() {
        JTermios.write(this.myPipe[1], new byte[1], 1);
    }

    public static int wait0(int pid) {
        PtyHelpers.OSFacade m_jpty = PtyHelpers.getInstance();
        int[] status = new int[1];
        if (pid < 0) {
            return -1;
        }
        while (m_jpty.waitpid(pid, status, 0) < 0 && JTermios.errno() == JTermios.EINTR) {
        }
        if (Pty.WIFEXITED(status[0])) {
            return Pty.WEXITSTATUS(status[0]);
        }
        return status[0];
    }

    static int WEXITSTATUS(int status) {
        return status >> 8 & 0xFF;
    }

    static boolean WIFEXITED(int status) {
        return Pty._WSTATUS(status) == 0;
    }

    private static int _WSTATUS(int status) {
        return status & 0x7F;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(byte[] buf, int len) throws IOException {
        boolean haveBytes;
        int fd = this.myMaster;
        if (fd == -1) {
            return -1;
        }
        Object object = this.mySelectLock;
        synchronized (object) {
            if (this.myPipe[0] == -1) {
                return -1;
            }
            haveBytes = useSelect ? Pty.select(this.myPipe[0], fd) : Pty.poll(this.myPipe[0], fd);
        }
        return haveBytes ? JTermios.read(fd, buf, len) : -1;
    }

    private static boolean poll(int pipeFd, int fd) {
        int[] poll_fds = new int[]{pipeFd, JTermios.POLLIN, fd, JTermios.POLLIN};
        while (JTermios.poll(poll_fds, 2, -1) <= 0) {
            int errno = JTermios.errno();
            if (errno == JTermios.EAGAIN || errno == JTermios.EINTR) continue;
            return false;
        }
        return (poll_fds[3] >> 16 & JTermios.POLLIN) != 0;
    }

    private static boolean select(int pipeFd, int fd) {
        FDSet set = JTermios.newFDSet();
        JTermios.FD_SET(pipeFd, set);
        JTermios.FD_SET(fd, set);
        JTermios.select(Math.max(fd, pipeFd) + 1, set, null, null, null);
        return JTermios.FD_ISSET(fd, set);
    }

    int write(byte[] buf, int len) throws IOException {
        return JTermios.write(this.myMaster, buf, len);
    }

    static {
        useSelect = Pty.isOSXLessThanOrEqualTo106();
        PTSNAME_LOCK = new Object();
    }
}

