/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.terminal;

import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.shell.terminal.service.TerminalService;
import org.apache.zeppelin.shell.terminal.websocket.TerminalSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminalManager.class);
    private HashMap<Integer, TerminalService> terminalSocket2Service = new HashMap();
    private HashMap<String, InterpreterContext> noteParagraphId2IntpContext = new HashMap();
    private static TerminalManager instance;

    public static synchronized TerminalManager getInstance() {
        if (instance == null) {
            instance = new TerminalManager();
        }
        return instance;
    }

    private TerminalManager() {
    }

    public TerminalService addTerminalService(TerminalSocket terminalSocket) {
        Integer terminalSocketHashcode = terminalSocket.hashCode();
        if (this.terminalSocket2Service.containsKey(terminalSocketHashcode)) {
            return this.terminalSocket2Service.get(terminalSocketHashcode);
        }
        TerminalService terminalService = new TerminalService();
        this.terminalSocket2Service.put(terminalSocketHashcode, terminalService);
        return terminalService;
    }

    public void removeTerminalService(TerminalSocket terminalSocket) {
        Integer terminalSocketHashcode = terminalSocket.hashCode();
        if (this.terminalSocket2Service.containsKey(terminalSocketHashcode)) {
            this.terminalSocket2Service.remove(terminalSocketHashcode);
        } else {
            LOGGER.error("Cann't find TerminalSocket: " + terminalSocketHashcode);
            LOGGER.error(this.terminalSocket2Service.toString());
        }
    }

    public void cleanIntpContext(String nodeId) {
        String keyPrex = nodeId + "@";
        for (Map.Entry<String, InterpreterContext> entity : this.noteParagraphId2IntpContext.entrySet()) {
            String key = entity.getKey();
            if (!key.contains(keyPrex)) continue;
            LOGGER.info("cleanIntpContext : " + key);
            this.noteParagraphId2IntpContext.remove(key);
        }
    }

    public void runCommand(String command) {
        for (Map.Entry<Integer, TerminalService> entry : this.terminalSocket2Service.entrySet()) {
            entry.getValue().onCommand(command + "\r");
        }
    }

    private String formatId(String noteId, String paragraphId) {
        return noteId + "@" + paragraphId;
    }

    public void setInterpreterContext(InterpreterContext intpContext) {
        String id = this.formatId(intpContext.getNoteId(), intpContext.getParagraphId());
        this.noteParagraphId2IntpContext.put(id, intpContext);
    }

    public void onWebSocketConnect(String noteId, String paragraphId) {
        String id = this.formatId(noteId, paragraphId);
        InterpreterContext intpContext = this.noteParagraphId2IntpContext.get(id);
        if (null != intpContext) {
            intpContext.getAngularObjectRegistry().add("TERMINAL_SOCKET_STATUS", (Object)"TERMINAL_SOCKET_CONNECT", intpContext.getNoteId(), intpContext.getParagraphId());
        } else {
            LOGGER.error("Cann't find InterpreterContext from : " + id);
            LOGGER.error(this.noteParagraphId2IntpContext.toString());
        }
    }

    public void onWebSocketClose(TerminalSocket terminalSocket, String noteId, String paragraphId) {
        String id = this.formatId(noteId, paragraphId);
        InterpreterContext intpContext = this.noteParagraphId2IntpContext.get(id);
        if (null != intpContext) {
            intpContext.getAngularObjectRegistry().add("TERMINAL_SOCKET_STATUS", (Object)"TERMINAL_SOCKET_CLOSE", intpContext.getNoteId(), intpContext.getParagraphId());
        } else {
            LOGGER.error("Cann't find InterpreterContext from : " + id);
            LOGGER.error(this.noteParagraphId2IntpContext.toString());
        }
        this.removeTerminalService(terminalSocket);
    }

    public void onWebSocketError(TerminalSocket terminalSocket, String noteId, String paragraphId) {
        String id = this.formatId(noteId, paragraphId);
        InterpreterContext intpContext = this.noteParagraphId2IntpContext.get(id);
        if (null != intpContext) {
            intpContext.getAngularObjectRegistry().add("TERMINAL_SOCKET_STATUS", (Object)"TERMINAL_SOCKET_ERROR", intpContext.getNoteId(), intpContext.getParagraphId());
        } else {
            LOGGER.error("Cann't find InterpreterContext from : " + id);
            LOGGER.error(this.noteParagraphId2IntpContext.toString());
        }
    }
}

