/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.shell.terminal.helper;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOHelper.class);

    public static void close(Closeable ... closables) {
        for (Closeable closable : closables) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), e);
            }
        }
    }

    public static synchronized void copyLibPty(Path dataDir) throws IOException {
        Path donePath = dataDir.resolve(".DONE");
        if (Files.exists(donePath, new LinkOption[0])) {
            return;
        }
        String jarPath = IOHelper.getClassPath(IOHelper.class) + File.separator;
        Set<String> nativeFiles = IOHelper.getNativeFiles();
        for (String nativeFile : nativeFiles) {
            Path nativePath = dataDir.resolve(nativeFile);
            if (!Files.notExists(nativePath, new LinkOption[0])) continue;
            Files.createDirectories(nativePath.getParent(), new FileAttribute[0]);
            InputStream inputStream = IOHelper.class.getResourceAsStream("/" + nativeFile);
            if (null == inputStream) {
                Path source = Paths.get(jarPath + nativeFile, new String[0]);
                if (!Files.exists(source, new LinkOption[0])) {
                    throw new IOException("Can't find pytlib file : " + jarPath + nativeFile);
                }
                LOGGER.info("Use the pytlib file {} outside the JAR package.", (Object)(jarPath + nativeFile));
                Files.copy(source, nativePath, new CopyOption[0]);
                continue;
            }
            LOGGER.info("Use the libpty file {} in the JAR package resource.", (Object)nativeFile);
            Files.copy(inputStream, nativePath, new CopyOption[0]);
            IOHelper.close(inputStream);
        }
        Files.createFile(donePath, new FileAttribute[0]);
    }

    private static Set<String> getNativeFiles() {
        HashSet<String> nativeFiles = new HashSet<String>();
        List<String> freebsd = Arrays.asList("libpty/freebsd/x86/libpty.so", "libpty/freebsd/x86_64/libpty.so");
        List<String> linux = Arrays.asList("libpty/linux/x86/libpty.so", "libpty/linux/x86_64/libpty.so");
        List<String> macosx = Arrays.asList("libpty/macosx/x86/libpty.dylib", "libpty/macosx/x86_64/libpty.dylib");
        List<String> win_x86 = Arrays.asList("libpty/win/x86/winpty.dll", "libpty/win/x86/winpty-agent.exe");
        List<String> win_x86_64 = Arrays.asList("libpty/win/x86_64/winpty.dll", "libpty/win/x86_64/winpty-agent.exe", "libpty/win/x86_64/cyglaunch.exe");
        List<String> win_xp = Arrays.asList("libpty/win/xp/winpty.dll", "libpty/win/xp/winpty-agent.exe");
        nativeFiles.addAll(freebsd);
        nativeFiles.addAll(linux);
        nativeFiles.addAll(macosx);
        nativeFiles.addAll(win_x86);
        nativeFiles.addAll(win_x86_64);
        nativeFiles.addAll(win_xp);
        return nativeFiles;
    }

    private static String getClassPath(Class clazz) throws UnsupportedEncodingException {
        URL url;
        String realPath;
        int pos;
        if (clazz == null) {
            throw new IllegalArgumentException("The parameter cannot be empty!");
        }
        ClassLoader loader = clazz.getClassLoader();
        String clsName = clazz.getName() + ".class";
        Package pack = clazz.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException("Do not transfer system classes!");
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(".") < 0) {
                path = packName + "/";
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(".");
                while (end != -1) {
                    path = path + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = path + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(path + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(path + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return realPath;
    }
}

