/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class FloatDecoder
extends AbstractDecoder
implements Decoder.Text<Float> {
    public static final FloatDecoder INSTANCE = new FloatDecoder();

    @Override
    public Float decode(String s2) throws DecodeException {
        try {
            Float val = Float.valueOf(Float.parseFloat(s2));
            if (val.isNaN()) {
                throw new DecodeException(s2, "NaN");
            }
            return val;
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s2, "Unable to parse float", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s2) {
        if (s2 == null) {
            return false;
        }
        try {
            Float val = Float.valueOf(Float.parseFloat(s2));
            return !val.isNaN();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

