/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ServerSocketFactory;
import py4j.Base64;
import py4j.CallbackClient;
import py4j.DefaultGatewayServerListener;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.NetworkUtil;
import py4j.Py4JJavaServer;
import py4j.Py4JNetworkException;
import py4j.Py4JPythonClient;
import py4j.Py4JServerConnection;
import py4j.StringUtil;
import py4j.commands.Command;

public class GatewayServer
extends DefaultGatewayServerListener
implements Py4JJavaServer,
Runnable {
    public static final String DEFAULT_ADDRESS = "127.0.0.1";
    public static final String DEFAULT_IPv6_ADDRESS = "::1";
    public static final int DEFAULT_PORT = 25333;
    public static final int DEFAULT_PYTHON_PORT = 25334;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    public static final String GATEWAY_SERVER_ID = "GATEWAY_SERVER";
    public static final Logger PY4J_LOGGER = Logger.getLogger("py4j");
    private final InetAddress address;
    private final int port;
    private int pythonPort;
    private InetAddress pythonAddress;
    private final Gateway gateway;
    private final int connectTimeout;
    private final int readTimeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private final List<Py4JServerConnection> connections = new ArrayList<Py4JServerConnection>();
    private final List<Class<? extends Command>> customCommands;
    private final CopyOnWriteArrayList<GatewayServerListener> listeners;
    private final ServerSocketFactory sSocketFactory;
    protected final String authToken;
    private ServerSocket sSocket;
    private boolean isShutdown = false;
    private boolean isShuttingDown = false;
    private final Lock lock = new ReentrantLock(true);

    public static void turnAllLoggingOn() {
        PY4J_LOGGER.setLevel(Level.ALL);
    }

    public static void turnLoggingOff() {
        PY4J_LOGGER.setLevel(Level.OFF);
    }

    public static void turnLoggingOn() {
        PY4J_LOGGER.setLevel(Level.INFO);
    }

    public static InetAddress defaultAddress() {
        try {
            return InetAddress.getByName(DEFAULT_ADDRESS);
        }
        catch (UnknownHostException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public static InetAddress defaultIPv6Address() {
        try {
            return InetAddress.getByName(DEFAULT_IPv6_ADDRESS);
        }
        catch (UnknownHostException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public GatewayServer() {
        this(null, 25333, 0, 0);
    }

    public GatewayServer(Object entryPoint) {
        this(entryPoint, 25333, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port) {
        this(entryPoint, port, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, InetAddress address, InetAddress pythonAddress, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this(entryPoint, port, address, connectTimeout, readTimeout, customCommands, new CallbackClient(pythonPort, pythonAddress), ServerSocketFactory.getDefault());
    }

    public void resetCallbackClient(InetAddress pythonAddress, int pythonPort) {
        this.gateway.resetCallbackClient(pythonAddress, pythonPort);
        this.pythonPort = pythonPort;
        this.pythonAddress = pythonAddress;
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout) {
        this(entryPoint, port, 25334, connectTimeout, readTimeout, null);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this(entryPoint, port, GatewayServer.defaultAddress(), connectTimeout, readTimeout, customCommands, new CallbackClient(pythonPort, GatewayServer.defaultAddress()), ServerSocketFactory.getDefault());
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, Py4JPythonClient cbClient) {
        this(entryPoint, port, GatewayServer.defaultAddress(), connectTimeout, readTimeout, customCommands, cbClient, ServerSocketFactory.getDefault());
    }

    public GatewayServer(Object entryPoint, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, Py4JPythonClient cbClient) {
        this(entryPoint, port, address, connectTimeout, readTimeout, customCommands, cbClient, ServerSocketFactory.getDefault());
    }

    public GatewayServer(Object entryPoint, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, Py4JPythonClient cbClient, ServerSocketFactory sSocketFactory) {
        this(entryPoint, port, address, connectTimeout, readTimeout, customCommands, cbClient, sSocketFactory, null);
    }

    GatewayServer(Object entryPoint, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, Py4JPythonClient cbClient, ServerSocketFactory sSocketFactory, String authToken) {
        this.port = port;
        this.address = address;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.gateway = new Gateway(entryPoint, cbClient);
        this.pythonPort = cbClient.getPort();
        this.pythonAddress = cbClient.getAddress();
        this.gateway.putObject(GATEWAY_SERVER_ID, this);
        this.customCommands = customCommands != null ? customCommands : new ArrayList<Class<? extends Command>>();
        this.listeners = new CopyOnWriteArrayList();
        this.sSocketFactory = sSocketFactory;
        this.authToken = authToken;
    }

    public GatewayServer(Gateway gateway, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, ServerSocketFactory sSocketFactory) {
        this(gateway, port, address, connectTimeout, readTimeout, customCommands, sSocketFactory, null);
    }

    private GatewayServer(Gateway gateway, int port, InetAddress address, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, ServerSocketFactory sSocketFactory, String authToken) {
        this.port = port;
        this.address = address;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.gateway = gateway;
        this.pythonPort = gateway.getCallbackClient().getPort();
        this.pythonAddress = gateway.getCallbackClient().getAddress();
        this.gateway.putObject(GATEWAY_SERVER_ID, this);
        this.customCommands = customCommands != null ? customCommands : new ArrayList<Class<? extends Command>>();
        this.listeners = new CopyOnWriteArrayList();
        this.sSocketFactory = sSocketFactory;
        this.authToken = authToken;
    }

    @Override
    public void addListener(GatewayServerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    @Override
    public void connectionStopped(Py4JServerConnection gatewayConnection) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                this.connections.remove(gatewayConnection);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Py4JServerConnection createConnection(Gateway gateway, Socket socket) throws IOException {
        GatewayConnection connection = new GatewayConnection(gateway, socket, this.authToken, this.customCommands, this.listeners);
        connection.startConnection();
        return connection;
    }

    protected void fireConnectionError(Exception e) {
        this.logger.log(Level.SEVERE, "Connection Server Error", e);
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireConnectionStarted(Py4JServerConnection gatewayConnection) {
        this.logger.info("Connection Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionStarted(gatewayConnection);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerError(Exception e) {
        boolean sendEvent = false;
        if (e.getMessage().toLowerCase().contains("socket closed")) {
            this.logger.log(Level.FINE, "Gateway Server Error", e);
        } else {
            sendEvent = true;
            this.logger.log(Level.SEVERE, "Gateway Server Error", e);
        }
        if (sendEvent) {
            for (GatewayServerListener listener : this.listeners) {
                try {
                    listener.serverError(e);
                }
                catch (Exception ex) {
                    this.logger.log(Level.SEVERE, "A listener crashed.", ex);
                }
            }
        }
    }

    protected void fireServerPostShutdown() {
        this.logger.fine("Gateway Server Post Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPostShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerPreShutdown() {
        this.logger.fine("Gateway Server Pre Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPreShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStarted() {
        this.logger.info("Gateway Server Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStarted();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStopped() {
        this.logger.info("Gateway Server Stopped");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStopped();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.address;
    }

    public Py4JPythonClient getCallbackClient() {
        return this.gateway.getCallbackClient();
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Gateway getGateway() {
        return this.gateway;
    }

    @Override
    public int getListeningPort() {
        int port = -1;
        try {
            if (this.sSocket.isBound()) {
                port = this.sSocket.getLocalPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public InetAddress getPythonAddress() {
        return this.pythonAddress;
    }

    @Override
    public int getPythonPort() {
        return this.pythonPort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    protected void processSocket(Socket socket) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                socket.setSoTimeout(this.readTimeout);
                Py4JServerConnection gatewayConnection = this.createConnection(this.gateway, socket);
                this.connections.add(gatewayConnection);
                this.fireConnectionStarted(gatewayConnection);
            }
        }
        catch (Exception e) {
            this.fireConnectionError(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(GatewayServerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        try {
            this.gateway.startup();
            this.fireServerStarted();
            this.addListener(this);
            while (!this.isShutdown) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.fireServerError(e);
        }
        this.fireServerStopped();
        this.removeListener(this);
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean shutdownCallbackClient) {
        this.fireServerPreShutdown();
        try {
            this.lock.lock();
            if (this.isShuttingDown) {
                return;
            }
            this.isShutdown = true;
            this.isShuttingDown = true;
            NetworkUtil.quietlyClose(this.sSocket);
            ArrayList<Py4JServerConnection> tempConnections = new ArrayList<Py4JServerConnection>(this.connections);
            for (Py4JServerConnection connection : tempConnections) {
                connection.shutdown();
            }
            this.connections.clear();
            this.gateway.shutdown(shutdownCallbackClient);
        }
        finally {
            this.isShuttingDown = false;
            this.lock.unlock();
        }
        this.fireServerPostShutdown();
    }

    @Override
    public void start() {
        this.start(true);
    }

    @Override
    public void start(boolean fork) {
        this.startSocket();
        if (fork) {
            Thread t2 = new Thread(this);
            t2.start();
        } else {
            this.run();
        }
    }

    protected void startSocket() throws Py4JNetworkException {
        try {
            this.sSocket = this.sSocketFactory.createServerSocket();
            this.sSocket.setSoTimeout(this.connectTimeout);
            this.sSocket.setReuseAddress(true);
            this.sSocket.bind(new InetSocketAddress(this.address, this.port), -1);
        }
        catch (IOException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public Object getPythonServerEntryPoint(Class[] interfacesToImplement) {
        return this.getCallbackClient().getPythonServerEntryPoint(this.gateway, interfacesToImplement);
    }

    public static void main(String[] args) {
        boolean dieOnBrokenPipe = false;
        boolean enableAuth = false;
        String usage = "usage: [--die-on-broken-pipe] [--enable-auth] port";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(1);
        }
        for (int i = 0; i < args.length - 1; ++i) {
            String opt = args[i];
            if (opt.equals("--die-on-broken-pipe")) {
                dieOnBrokenPipe = true;
                continue;
            }
            if (opt.equals("--enable-auth")) {
                enableAuth = true;
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        int port = Integer.parseInt(args[args.length - 1]);
        String authToken = null;
        if (enableAuth) {
            SecureRandom rnd = new SecureRandom();
            byte[] token = new byte[32];
            rnd.nextBytes(token);
            authToken = Base64.encodeToString(token, false);
        }
        GatewayServer gatewayServer = new GatewayServerBuilder().javaPort(port).authToken(authToken).build();
        gatewayServer.start();
        int listening_port = gatewayServer.getListeningPort();
        System.out.println("" + listening_port);
        if (authToken != null) {
            System.out.println(authToken);
        }
        if (dieOnBrokenPipe) {
            try {
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in, Charset.forName("UTF-8")));
                stdin.readLine();
                System.exit(0);
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
    }

    public List<Class<? extends Command>> getCustomCommands() {
        return Collections.unmodifiableList(this.customCommands);
    }

    @Override
    public List<GatewayServerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    static {
        GatewayServer.turnLoggingOff();
    }

    public static class GatewayServerBuilder {
        private int javaPort = 25333;
        private InetAddress javaAddress = GatewayServer.defaultAddress();
        private int connectTimeout = 0;
        private int readTimeout = 0;
        private Gateway gateway;
        private ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        private Object entryPoint;
        private Py4JPythonClient callbackClient;
        private List<Class<? extends Command>> customCommands;
        private String authToken;

        public GatewayServerBuilder() {
            this(null);
        }

        public GatewayServerBuilder(Object entryPoint) {
            this.entryPoint = entryPoint;
        }

        public GatewayServer build() {
            if (this.gateway == null) {
                if (this.callbackClient == null) {
                    this.callbackClient = new CallbackClient(25334);
                }
                return new GatewayServer(this.entryPoint, this.javaPort, this.javaAddress, this.connectTimeout, this.readTimeout, this.customCommands, this.callbackClient, this.serverSocketFactory, this.authToken);
            }
            return new GatewayServer(this.gateway, this.javaPort, this.javaAddress, this.connectTimeout, this.readTimeout, this.customCommands, this.serverSocketFactory, this.authToken);
        }

        public GatewayServerBuilder gateway(Gateway gateway) {
            this.gateway = gateway;
            return this;
        }

        public GatewayServerBuilder javaPort(int javaPort) {
            this.javaPort = javaPort;
            return this;
        }

        public GatewayServerBuilder javaAddress(InetAddress javaAddress) {
            this.javaAddress = javaAddress;
            return this;
        }

        public GatewayServerBuilder callbackClient(int pythonPort, InetAddress pythonAddress) {
            this.callbackClient = new CallbackClient(pythonPort, pythonAddress);
            return this;
        }

        public GatewayServerBuilder callbackClient(int pythonPort, InetAddress pythonAddress, String authToken) {
            this.callbackClient = new CallbackClient(pythonPort, pythonAddress, authToken);
            return this;
        }

        public GatewayServerBuilder callbackClient(CallbackClient callbackClient) {
            this.callbackClient = callbackClient;
            return this;
        }

        public GatewayServerBuilder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public GatewayServerBuilder readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public GatewayServerBuilder serverSocketFactory(ServerSocketFactory serverSocketFactory) {
            this.serverSocketFactory = serverSocketFactory;
            return this;
        }

        public GatewayServerBuilder entryPoint(Object entryPoint) {
            this.entryPoint = entryPoint;
            return this;
        }

        public GatewayServerBuilder customCommands(List<Class<? extends Command>> customCommands) {
            this.customCommands = customCommands;
            return this;
        }

        public GatewayServerBuilder authToken(String authToken) {
            this.authToken = StringUtil.escape(authToken);
            return this;
        }
    }
}

