/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class SharedMetricRegistries {
    private static final ConcurrentMap<String, MetricRegistry> REGISTRIES = new ConcurrentHashMap<String, MetricRegistry>();
    private static AtomicReference<String> defaultRegistryName = new AtomicReference();

    static void setDefaultRegistryName(AtomicReference<String> defaultRegistryName) {
        SharedMetricRegistries.defaultRegistryName = defaultRegistryName;
    }

    private SharedMetricRegistries() {
    }

    public static void clear() {
        REGISTRIES.clear();
    }

    public static Set<String> names() {
        return REGISTRIES.keySet();
    }

    public static void remove(String key2) {
        REGISTRIES.remove(key2);
    }

    public static MetricRegistry add(String name2, MetricRegistry registry) {
        return REGISTRIES.putIfAbsent(name2, registry);
    }

    public static MetricRegistry getOrCreate(String name2) {
        MetricRegistry existing = (MetricRegistry)REGISTRIES.get(name2);
        if (existing == null) {
            MetricRegistry created = new MetricRegistry();
            MetricRegistry raced = SharedMetricRegistries.add(name2, created);
            if (raced == null) {
                return created;
            }
            return raced;
        }
        return existing;
    }

    public static synchronized MetricRegistry setDefault(String name2) {
        MetricRegistry registry = SharedMetricRegistries.getOrCreate(name2);
        return SharedMetricRegistries.setDefault(name2, registry);
    }

    public static MetricRegistry setDefault(String name2, MetricRegistry metricRegistry) {
        if (defaultRegistryName.compareAndSet(null, name2)) {
            SharedMetricRegistries.add(name2, metricRegistry);
            return metricRegistry;
        }
        throw new IllegalStateException("Default metric registry name is already set.");
    }

    public static MetricRegistry getDefault() {
        MetricRegistry metricRegistry = SharedMetricRegistries.tryGetDefault();
        if (metricRegistry == null) {
            throw new IllegalStateException("Default registry name has not been set.");
        }
        return metricRegistry;
    }

    public static MetricRegistry tryGetDefault() {
        String name2 = defaultRegistryName.get();
        if (name2 != null) {
            return SharedMetricRegistries.getOrCreate(name2);
        }
        return null;
    }
}

