/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.AbstractX86StubCompiler;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jnr.x86asm.Asm;
import com.kenai.jnr.x86asm.Assembler;
import com.kenai.jnr.x86asm.Register;

final class X86_32StubCompiler
extends AbstractX86StubCompiler {
    X86_32StubCompiler() {
    }

    boolean canCompile(Class returnType, Class[] parameterTypes, CallingConvention convention) {
        if (returnType != Byte.TYPE && returnType != Short.TYPE && returnType != Integer.TYPE && returnType != Long.TYPE && returnType != Float.TYPE && returnType != Double.TYPE && returnType != Void.TYPE) {
            return false;
        }
        if (convention != CallingConvention.DEFAULT) {
            return false;
        }
        int fCount = 0;
        int iCount = 0;
        for (Class t : parameterTypes) {
            if (t == Byte.TYPE || t == Short.TYPE || t == Integer.TYPE || t == Long.TYPE) {
                ++iCount;
                continue;
            }
            if (t == Float.TYPE || t == Double.TYPE) {
                ++fCount;
                continue;
            }
            return false;
        }
        return true;
    }

    void compile(Function function, String name2, Class returnType, Class[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        int psize = 0;
        for (Class t : parameterTypes) {
            if (t == Byte.TYPE || t == Short.TYPE || t == Integer.TYPE || t == Float.TYPE) {
                psize += 4;
                continue;
            }
            if (t == Long.TYPE || t == Double.TYPE) {
                psize += 8;
                continue;
            }
            throw new IllegalArgumentException("invalid parameter type" + t);
        }
        int rsize = 0;
        if (Double.TYPE == returnType || Float.TYPE == returnType) {
            rsize = 16;
        } else if (Long.TYPE == returnType) {
            rsize = 8;
        } else if (Byte.TYPE == returnType || Short.TYPE == returnType || Integer.TYPE == returnType) {
            rsize = 4;
        } else if (Void.TYPE == returnType) {
            rsize = 0;
        } else {
            throw new IllegalArgumentException("invalid return type " + returnType);
        }
        int stackadj = X86_32StubCompiler.align(Math.max(psize, rsize) + 4, 16) - 4;
        Assembler a = new Assembler(Asm.X86_32);
        a.sub(Asm.esp, Asm.imm((long)stackadj));
        for (int i2 = 0; i2 < psize; i2 += 4) {
            a.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)(stackadj + 4 + 8 + i2)));
            a.mov(Asm.dword_ptr((Register)Asm.esp, (long)i2), Asm.eax);
        }
        a.mov(Asm.eax, Asm.imm((long)function.getFunctionAddress()));
        a.call(Asm.eax);
        if (saveErrno) {
            int save = 0;
            if (Float.TYPE == returnType) {
                a.fstp(Asm.dword_ptr((Register)Asm.esp, (long)save));
            } else if (Double.TYPE == returnType) {
                a.fstp(Asm.qword_ptr((Register)Asm.esp, (long)save));
            } else if (Long.TYPE == returnType) {
                a.mov(Asm.dword_ptr((Register)Asm.esp, (long)save), Asm.eax);
                a.mov(Asm.dword_ptr((Register)Asm.esp, (long)(save + 4)), Asm.edx);
            } else if (Void.TYPE != returnType) {
                a.mov(Asm.dword_ptr((Register)Asm.esp, (long)save), Asm.eax);
            }
            a.mov(Asm.eax, Asm.imm((long)errnoFunctionAddress));
            a.call(Asm.eax);
            if (Float.TYPE == returnType) {
                a.fld(Asm.dword_ptr((Register)Asm.esp, (long)save));
            } else if (Double.TYPE == returnType) {
                a.fld(Asm.qword_ptr((Register)Asm.esp, (long)save));
            } else if (Long.TYPE == returnType) {
                a.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)save));
                a.mov(Asm.edx, Asm.dword_ptr((Register)Asm.esp, (long)(save + 4)));
            } else if (Void.TYPE != returnType) {
                a.mov(Asm.eax, Asm.dword_ptr((Register)Asm.esp, (long)save));
            }
        }
        a.add(Asm.esp, Asm.imm((long)stackadj));
        a.ret();
        this.stubs.add(new AbstractX86StubCompiler.Stub(name2, CodegenUtils.sig(returnType, parameterTypes), a));
    }
}

