/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.jwk;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.KeyUseAndOpsConsistency;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.ThumbprintUtils;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.io.Serializable;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public abstract class JWK
implements JSONAware,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE = "application/jwk+json; charset=UTF-8";
    private final KeyType kty;
    private final KeyUse use;
    private final Set<KeyOperation> ops;
    private final Algorithm alg;
    private final String kid;
    private final URI x5u;
    @Deprecated
    private final Base64URL x5t;
    private Base64URL x5t256;
    private final List<Base64> x5c;
    private final KeyStore keyStore;

    protected JWK(KeyType kty, KeyUse use, Set<KeyOperation> ops, Algorithm alg, String kid, URI x5u, Base64URL x5t, Base64URL x5t256, List<Base64> x5c, KeyStore ks) {
        if (kty == null) {
            throw new IllegalArgumentException("The key type \"kty\" parameter must not be null");
        }
        this.kty = kty;
        if (!KeyUseAndOpsConsistency.areConsistent(use, ops)) {
            throw new IllegalArgumentException("The key use \"use\" and key options \"key_opts\" parameters are not consistent, see RFC 7517, section 4.3");
        }
        this.use = use;
        this.ops = ops;
        this.alg = alg;
        this.kid = kid;
        this.x5u = x5u;
        this.x5t = x5t;
        this.x5t256 = x5t256;
        this.x5c = x5c;
        this.keyStore = ks;
    }

    public KeyType getKeyType() {
        return this.kty;
    }

    public KeyUse getKeyUse() {
        return this.use;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.ops;
    }

    public Algorithm getAlgorithm() {
        return this.alg;
    }

    public String getKeyID() {
        return this.kid;
    }

    public URI getX509CertURL() {
        return this.x5u;
    }

    @Deprecated
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public Base64URL getX509CertSHA256Thumbprint() {
        return this.x5t256;
    }

    public List<Base64> getX509CertChain() {
        if (this.x5c == null) {
            return null;
        }
        return Collections.unmodifiableList(this.x5c);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public abstract LinkedHashMap<String, ?> getRequiredParams();

    public Base64URL computeThumbprint() throws JOSEException {
        return this.computeThumbprint("SHA-256");
    }

    public Base64URL computeThumbprint(String hashAlg) throws JOSEException {
        return ThumbprintUtils.compute(hashAlg, this);
    }

    public abstract boolean isPrivate();

    public abstract JWK toPublicJWK();

    public abstract int size();

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"kty", (Object)this.kty.getValue());
        if (this.use != null) {
            o.put((Object)"use", (Object)this.use.identifier());
        }
        if (this.ops != null) {
            ArrayList<String> sl = new ArrayList<String>(this.ops.size());
            for (KeyOperation op : this.ops) {
                sl.add(op.identifier());
            }
            o.put((Object)"key_ops", sl);
        }
        if (this.alg != null) {
            o.put((Object)"alg", (Object)this.alg.getName());
        }
        if (this.kid != null) {
            o.put((Object)"kid", (Object)this.kid);
        }
        if (this.x5u != null) {
            o.put((Object)"x5u", (Object)this.x5u.toString());
        }
        if (this.x5t != null) {
            o.put((Object)"x5t", (Object)this.x5t.toString());
        }
        if (this.x5t256 != null) {
            o.put((Object)"x5t#S256", (Object)this.x5t256.toString());
        }
        if (this.x5c != null) {
            o.put((Object)"x5c", this.x5c);
        }
        return o;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWK parse(String s2) throws ParseException {
        return JWK.parse(JSONObjectUtils.parse(s2));
    }

    public static JWK parse(JSONObject jsonObject) throws ParseException {
        KeyType kty = KeyType.parse(JSONObjectUtils.getString(jsonObject, "kty"));
        if (kty == KeyType.EC) {
            return ECKey.parse(jsonObject);
        }
        if (kty == KeyType.RSA) {
            return RSAKey.parse(jsonObject);
        }
        if (kty == KeyType.OCT) {
            return OctetSequenceKey.parse(jsonObject);
        }
        throw new ParseException("Unsupported key type \"kty\" parameter: " + kty, 0);
    }

    public static JWK parse(X509Certificate cert) throws JOSEException {
        if (cert.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.parse(cert);
        }
        if (cert.getPublicKey() instanceof ECPublicKey) {
            return ECKey.parse(cert);
        }
        throw new JOSEException("Unsupported public key algorithm: " + cert.getPublicKey().getAlgorithm());
    }

    public static JWK load(KeyStore keyStore, String alias2, char[] pin) throws KeyStoreException, JOSEException {
        Certificate cert = keyStore.getCertificate(alias2);
        if (cert == null) {
            return OctetSequenceKey.load(keyStore, alias2, pin);
        }
        if (cert.getPublicKey() instanceof RSAPublicKey) {
            return RSAKey.load(keyStore, alias2, pin);
        }
        if (cert.getPublicKey() instanceof ECPublicKey) {
            return ECKey.load(keyStore, alias2, pin);
        }
        throw new JOSEException("Unsupported public key algorithm: " + cert.getPublicKey().getAlgorithm());
    }
}

