/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        char c;
        if (parameterList == null) {
            return;
        }
        int length2 = parameterList.length();
        if (length2 <= 0) {
            return;
        }
        int i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, 0);
        while (i2 < length2 && (c = parameterList.charAt(i2)) == ';') {
            String value2;
            ++i2;
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length2) {
                return;
            }
            int lastIndex = i2;
            while (i2 < length2 && MimeTypeParameterList.isTokenChar(parameterList.charAt(i2))) {
                ++i2;
            }
            String name2 = parameterList.substring(lastIndex, i2).toLowerCase(Locale.ENGLISH);
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length2 || parameterList.charAt(i2) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++i2;
            if ((i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2)) >= length2) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name2);
            }
            c = parameterList.charAt(i2);
            if (c == '\"') {
                if (++i2 >= length2) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                lastIndex = i2;
                while (i2 < length2 && (c = parameterList.charAt(i2)) != '\"') {
                    if (c == '\\') {
                        ++i2;
                    }
                    ++i2;
                }
                if (c != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                value2 = MimeTypeParameterList.unquote(parameterList.substring(lastIndex, i2));
                ++i2;
            } else if (MimeTypeParameterList.isTokenChar(c)) {
                lastIndex = i2;
                while (i2 < length2 && MimeTypeParameterList.isTokenChar(parameterList.charAt(i2))) {
                    ++i2;
                }
                value2 = parameterList.substring(lastIndex, i2);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + i2);
            }
            this.parameters.put(name2, value2);
            i2 = MimeTypeParameterList.skipWhiteSpace(parameterList, i2);
        }
        if (i2 < length2) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name2) {
        return (String)this.parameters.get(name2.trim().toLowerCase(Locale.ENGLISH));
    }

    public void set(String name2, String value2) {
        this.parameters.put(name2.trim().toLowerCase(Locale.ENGLISH), value2);
    }

    public void remove(String name2) {
        this.parameters.remove(name2.trim().toLowerCase(Locale.ENGLISH));
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys2 = this.parameters.keys();
        while (keys2.hasMoreElements()) {
            String key2 = (String)keys2.nextElement();
            buffer.append("; ");
            buffer.append(key2);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key2)));
        }
        return buffer.toString();
    }

    private static boolean isTokenChar(char c) {
        return c > ' ' && c < '\u007f' && TSPECIALS.indexOf(c) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i2) {
        int length2 = rawdata.length();
        while (i2 < length2 && Character.isWhitespace(rawdata.charAt(i2))) {
            ++i2;
        }
        return i2;
    }

    private static String quote(String value2) {
        boolean needsQuotes = false;
        int length2 = value2.length();
        for (int i2 = 0; i2 < length2 && !needsQuotes; ++i2) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value2.charAt(i2));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length2 * 1.5));
            buffer.append('\"');
            for (int i3 = 0; i3 < length2; ++i3) {
                char c = value2.charAt(i3);
                if (c == '\\' || c == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value2;
    }

    private static String unquote(String value2) {
        int valueLength = value2.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped = false;
        for (int i2 = 0; i2 < valueLength; ++i2) {
            char currentChar = value2.charAt(i2);
            if (!escaped && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped) {
                buffer.append(currentChar);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return buffer.toString();
    }
}

