/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.stream;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.stream.CryptoInputStream;
import org.apache.commons.crypto.stream.input.ChannelInput;
import org.apache.commons.crypto.stream.input.Input;
import org.apache.commons.crypto.stream.input.StreamInput;
import org.apache.commons.crypto.utils.Utils;

public class CtrCryptoInputStream
extends CryptoInputStream {
    private long streamOffset = 0L;
    private final byte[] initIV;
    private byte[] iv;
    private byte padding;
    private boolean cipherReset = false;

    public CtrCryptoInputStream(Properties props, InputStream in, byte[] key2, byte[] iv) throws IOException {
        this(props, in, key2, iv, 0L);
    }

    public CtrCryptoInputStream(Properties props, ReadableByteChannel in, byte[] key2, byte[] iv) throws IOException {
        this(props, in, key2, iv, 0L);
    }

    protected CtrCryptoInputStream(InputStream in, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(in, cipher, bufferSize, key2, iv, 0L);
    }

    protected CtrCryptoInputStream(ReadableByteChannel in, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(in, cipher, bufferSize, key2, iv, 0L);
    }

    protected CtrCryptoInputStream(Input input, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv) throws IOException {
        this(input, cipher, bufferSize, key2, iv, 0L);
    }

    public CtrCryptoInputStream(Properties props, InputStream in, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(in, Utils.getCipherInstance("AES/CTR/NoPadding", props), CryptoInputStream.getBufferSize(props), key2, iv, streamOffset);
    }

    public CtrCryptoInputStream(Properties props, ReadableByteChannel in, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(in, Utils.getCipherInstance("AES/CTR/NoPadding", props), CryptoInputStream.getBufferSize(props), key2, iv, streamOffset);
    }

    protected CtrCryptoInputStream(InputStream in, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(new StreamInput(in, bufferSize), cipher, bufferSize, key2, iv, streamOffset);
    }

    protected CtrCryptoInputStream(ReadableByteChannel in, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        this(new ChannelInput(in), cipher, bufferSize, key2, iv, streamOffset);
    }

    protected CtrCryptoInputStream(Input input, CryptoCipher cipher, int bufferSize, byte[] key2, byte[] iv, long streamOffset) throws IOException {
        super(input, cipher, bufferSize, (Key)new SecretKeySpec(key2, "AES"), (AlgorithmParameterSpec)new IvParameterSpec(iv));
        this.initIV = (byte[])iv.clone();
        this.iv = (byte[])iv.clone();
        CryptoInputStream.checkStreamCipher(cipher);
        this.resetStreamOffset(streamOffset);
    }

    @Override
    public long skip(long n) throws IOException {
        Utils.checkArgument(n >= 0L, "Negative skip length.");
        this.checkStream();
        if (n == 0L) {
            return 0L;
        }
        if (n <= (long)this.outBuffer.remaining()) {
            int pos2 = this.outBuffer.position() + (int)n;
            this.outBuffer.position(pos2);
            return n;
        }
        long skipped = this.input.skip(n -= (long)this.outBuffer.remaining());
        if (skipped < 0L) {
            skipped = 0L;
        }
        long pos3 = this.streamOffset + skipped;
        this.resetStreamOffset(pos3);
        return skipped += (long)this.outBuffer.remaining();
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        this.checkStream();
        int unread = this.outBuffer.remaining();
        if (unread <= 0) {
            int n = this.input.read(this.inBuffer);
            if (n <= 0) {
                return n;
            }
            this.streamOffset += (long)n;
            if (buf.isDirect() && buf.remaining() >= this.inBuffer.position() && this.padding == 0) {
                this.decryptInPlace(buf);
                this.padding = this.postDecryption(this.streamOffset);
                return n;
            }
            this.decrypt();
            this.padding = this.postDecryption(this.streamOffset);
        }
        unread = this.outBuffer.remaining();
        int toRead = buf.remaining();
        if (toRead <= unread) {
            int limit2 = this.outBuffer.limit();
            this.outBuffer.limit(this.outBuffer.position() + toRead);
            buf.put(this.outBuffer);
            this.outBuffer.limit(limit2);
            return toRead;
        }
        buf.put(this.outBuffer);
        return unread;
    }

    public void seek(long position) throws IOException {
        Utils.checkArgument(position >= 0L, "Cannot seek to negative offset.");
        this.checkStream();
        if (position >= this.getStreamPosition() && position <= this.getStreamOffset()) {
            int forward = (int)(position - this.getStreamPosition());
            if (forward > 0) {
                this.outBuffer.position(this.outBuffer.position() + forward);
            }
        } else {
            this.input.seek(position);
            this.resetStreamOffset(position);
        }
    }

    protected long getStreamOffset() {
        return this.streamOffset;
    }

    protected void setStreamOffset(long streamOffset) {
        this.streamOffset = streamOffset;
    }

    protected long getStreamPosition() {
        return this.streamOffset - (long)this.outBuffer.remaining();
    }

    @Override
    protected int decryptMore() throws IOException {
        int n = this.input.read(this.inBuffer);
        if (n <= 0) {
            return n;
        }
        this.streamOffset += (long)n;
        this.decrypt();
        this.padding = this.postDecryption(this.streamOffset);
        return this.outBuffer.remaining();
    }

    @Override
    protected void decrypt() throws IOException {
        Utils.checkState(this.inBuffer.position() >= this.padding);
        if (this.inBuffer.position() == this.padding) {
            return;
        }
        this.inBuffer.flip();
        this.outBuffer.clear();
        this.decryptBuffer(this.outBuffer);
        this.inBuffer.clear();
        this.outBuffer.flip();
        if (this.padding > 0) {
            this.outBuffer.position(this.padding);
        }
    }

    protected void decryptInPlace(ByteBuffer buf) throws IOException {
        Utils.checkState(this.inBuffer.position() >= this.padding);
        Utils.checkState(buf.isDirect());
        Utils.checkState(buf.remaining() >= this.inBuffer.position());
        Utils.checkState(this.padding == 0);
        if (this.inBuffer.position() == this.padding) {
            return;
        }
        this.inBuffer.flip();
        this.decryptBuffer(buf);
        this.inBuffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrypt(ByteBuffer buf, int offset2, int len) throws IOException {
        int pos2 = buf.position();
        int limit2 = buf.limit();
        int n = 0;
        while (n < len) {
            buf.position(offset2 + n);
            buf.limit(offset2 + n + Math.min(len - n, this.inBuffer.remaining()));
            this.inBuffer.put(buf);
            try {
                this.decrypt();
                buf.position(offset2 + n);
                buf.limit(limit2);
                n += this.outBuffer.remaining();
                buf.put(this.outBuffer);
            }
            finally {
                this.padding = this.postDecryption(this.streamOffset - (long)(len - n));
            }
        }
        buf.position(pos2);
    }

    protected byte postDecryption(long position) throws IOException {
        byte padding = 0;
        if (this.cipherReset) {
            this.resetCipher(position);
            padding = this.getPadding(position);
            this.inBuffer.position(padding);
        }
        return padding;
    }

    protected byte[] getInitIV() {
        return this.initIV;
    }

    protected long getCounter(long position) {
        return position / (long)this.cipher.getBlockSize();
    }

    protected byte getPadding(long position) {
        return (byte)(position % (long)this.cipher.getBlockSize());
    }

    @Override
    protected void initCipher() {
    }

    protected void resetCipher(long position) throws IOException {
        long counter = this.getCounter(position);
        CtrCryptoInputStream.calculateIV(this.initIV, counter, this.iv);
        try {
            this.cipher.init(2, this.key, new IvParameterSpec(this.iv));
        }
        catch (InvalidKeyException e) {
            throw new IOException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IOException(e);
        }
        this.cipherReset = false;
    }

    protected void resetStreamOffset(long offset2) throws IOException {
        this.streamOffset = offset2;
        this.inBuffer.clear();
        this.outBuffer.clear();
        this.outBuffer.limit(0);
        this.resetCipher(offset2);
        this.padding = this.getPadding(offset2);
        this.inBuffer.position(this.padding);
    }

    protected void decryptBuffer(ByteBuffer out) throws IOException {
        int inputSize = this.inBuffer.remaining();
        try {
            int n = this.cipher.update(this.inBuffer, out);
            if (n < inputSize) {
                this.cipher.doFinal(this.inBuffer, out);
                this.cipherReset = true;
            }
        }
        catch (ShortBufferException e) {
            throw new IOException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (BadPaddingException e) {
            throw new IOException(e);
        }
    }

    static void calculateIV(byte[] initIV, long counter, byte[] IV) {
        Utils.checkArgument(initIV.length == 16);
        Utils.checkArgument(IV.length == 16);
        int i2 = IV.length;
        int j = 0;
        int sum2 = 0;
        while (i2-- > 0) {
            sum2 = (initIV[i2] & 0xFF) + (sum2 >>> 8);
            if (j++ < 8) {
                sum2 += (byte)counter & 0xFF;
                counter >>>= 8;
            }
            IV[i2] = (byte)sum2;
        }
    }
}

