/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import org.apache.commons.lang3.mutable.Mutable;

public class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable<Number> {
    private static final long serialVersionUID = 1587163916L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value2) {
        this.value = value2;
    }

    public MutableDouble(Number value2) {
        this.value = value2.doubleValue();
    }

    public MutableDouble(String value2) {
        this.value = Double.parseDouble(value2);
    }

    public void add(double operand) {
        this.value += operand;
    }

    public void add(Number operand) {
        this.value += operand.doubleValue();
    }

    public double addAndGet(double operand) {
        this.value += operand;
        return this.value;
    }

    public double addAndGet(Number operand) {
        this.value += operand.doubleValue();
        return this.value;
    }

    @Override
    public int compareTo(MutableDouble other) {
        return Double.compare(this.value, other.value);
    }

    public void decrement() {
        this.value -= 1.0;
    }

    public double decrementAndGet() {
        this.value -= 1.0;
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        return obj instanceof MutableDouble && Double.doubleToLongBits(((MutableDouble)obj).value) == Double.doubleToLongBits(this.value);
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    public double getAndAdd(double operand) {
        double last2 = this.value;
        this.value += operand;
        return last2;
    }

    public double getAndAdd(Number operand) {
        double last2 = this.value;
        this.value += operand.doubleValue();
        return last2;
    }

    public double getAndDecrement() {
        double last2 = this.value;
        this.value -= 1.0;
        return last2;
    }

    public double getAndIncrement() {
        double last2 = this.value;
        this.value += 1.0;
        return last2;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public void increment() {
        this.value += 1.0;
    }

    public double incrementAndGet() {
        this.value += 1.0;
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public void setValue(double value2) {
        this.value = value2;
    }

    @Override
    public void setValue(Number value2) {
        this.value = value2.doubleValue();
    }

    public void subtract(double operand) {
        this.value -= operand;
    }

    public void subtract(Number operand) {
        this.value -= operand.doubleValue();
    }

    public Double toDouble() {
        return this.doubleValue();
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

