/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
abstract class SyncCoprocessorRpcChannel
implements CoprocessorRpcChannel {
    private static final Logger LOG = LoggerFactory.getLogger(SyncCoprocessorRpcChannel.class);

    SyncCoprocessorRpcChannel() {
    }

    @Override
    @InterfaceAudience.Private
    public void callMethod(Descriptors.MethodDescriptor method2, RpcController controller, Message request, Message responsePrototype, RpcCallback<Message> callback) {
        Message response = null;
        try {
            response = this.callExecService(controller, method2, request, responsePrototype);
        }
        catch (IOException ioe) {
            LOG.warn("Call failed on IOException", ioe);
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        if (callback != null) {
            callback.run(response);
        }
    }

    @Override
    @InterfaceAudience.Private
    public Message callBlockingMethod(Descriptors.MethodDescriptor method2, RpcController controller, Message request, Message responsePrototype) throws ServiceException {
        try {
            return this.callExecService(controller, method2, request, responsePrototype);
        }
        catch (IOException ioe) {
            throw new ServiceException("Error calling method " + method2.getFullName(), ioe);
        }
    }

    protected abstract Message callExecService(RpcController var1, Descriptors.MethodDescriptor var2, Message var3, Message var4) throws IOException;
}

