/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.protobuf.generated.ComparatorProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class BinaryComponentComparator
extends ByteArrayComparable {
    private int offset;

    public BinaryComponentComparator(byte[] value2, int offset2) {
        super(value2);
        this.offset = offset2;
    }

    @Override
    public int compareTo(byte[] value2) {
        return this.compareTo(value2, 0, value2.length);
    }

    @Override
    public int compareTo(byte[] value2, int offset2, int length2) {
        return Bytes.compareTo(this.value, 0, this.value.length, value2, offset2 + this.offset, this.value.length);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryComponentComparator)) {
            return false;
        }
        BinaryComponentComparator bcc = (BinaryComponentComparator)other;
        return this.offset == bcc.offset && this.compareTo(bcc.value) == 0;
    }

    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.offset;
        return result2;
    }

    @Override
    public byte[] toByteArray() {
        ComparatorProtos.BinaryComponentComparator.Builder builder = ComparatorProtos.BinaryComponentComparator.newBuilder();
        builder.setValue(ByteString.copyFrom(this.value));
        builder.setOffset(this.offset);
        return builder.build().toByteArray();
    }

    public static BinaryComponentComparator parseFrom(byte[] pbBytes) throws DeserializationException {
        ComparatorProtos.BinaryComponentComparator proto;
        try {
            proto = ComparatorProtos.BinaryComponentComparator.parseFrom(pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new BinaryComponentComparator(proto.getValue().toByteArray(), proto.getOffset());
    }

    @Override
    boolean areSerializedFieldsEqual(ByteArrayComparable other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BinaryComponentComparator)) {
            return false;
        }
        return super.areSerializedFieldsEqual(other);
    }
}

