/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferKeyOnlyKeyValue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractDataBlockEncoder
implements DataBlockEncoder {
    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding encoding2, byte[] header, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(encoding2, header, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(meta);
    }

    protected void postEncoding(HFileBlockEncodingContext encodingCtx) throws IOException {
        if (encodingCtx.getDataBlockEncoding() != DataBlockEncoding.NONE) {
            encodingCtx.postEncoding(BlockType.ENCODED_DATA);
        } else {
            encodingCtx.postEncoding(BlockType.DATA);
        }
    }

    protected Cell createFirstKeyCell(ByteBuffer key2, int keyLength) {
        if (key2.hasArray()) {
            return new KeyValue.KeyOnlyKeyValue(key2.array(), key2.arrayOffset() + key2.position(), keyLength);
        }
        return new ByteBufferKeyOnlyKeyValue(key2, key2.position(), keyLength);
    }

    protected static abstract class AbstractEncodedSeeker
    implements DataBlockEncoder.EncodedSeeker {
        protected HFileBlockDecodingContext decodingCtx;

        public AbstractEncodedSeeker(HFileBlockDecodingContext decodingCtx) {
            this.decodingCtx = decodingCtx;
        }

        protected boolean includesMvcc() {
            return this.decodingCtx.getHFileContext().isIncludesMvcc();
        }

        protected boolean includesTags() {
            return this.decodingCtx.getHFileContext().isIncludesTags();
        }
    }
}

