/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Stream;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.util.AtomicUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FastLongHistogram {
    public static final int DEFAULT_NBINS = 255;
    public static final double[] DEFAULT_QUANTILES = new double[]{0.25, 0.5, 0.75, 0.9, 0.95, 0.98, 0.99, 0.999};
    private volatile Bins bins;

    public FastLongHistogram() {
        this(255);
    }

    public FastLongHistogram(int numOfBins) {
        this.bins = new Bins(numOfBins);
    }

    public FastLongHistogram(int numOfBins, long min2, long max2) {
        this(numOfBins);
        Bins bins = new Bins(numOfBins);
        bins.add(min2, 1L);
        bins.add(max2, 1L);
        this.bins = new Bins(bins, numOfBins, 0.01, 0.999);
    }

    private FastLongHistogram(Bins bins) {
        this.bins = bins;
    }

    public void add(long value2, long count2) {
        this.bins.add(value2, count2);
    }

    public long[] getQuantiles(double[] quantiles) {
        return this.bins.getQuantiles(quantiles);
    }

    public long[] getQuantiles() {
        return this.bins.getQuantiles(DEFAULT_QUANTILES);
    }

    public long getMin() {
        return this.bins.getMin();
    }

    public long getMax() {
        return this.bins.max.get();
    }

    public long getCount() {
        return this.bins.count.sum();
    }

    public long getMean() {
        return this.bins.getMean();
    }

    public long getNumAtOrBelow(long value2) {
        return this.bins.getNumAtOrBelow(value2);
    }

    public Snapshot snapshotAndReset() {
        final Bins oldBins = this.bins;
        this.bins = new Bins(this.bins, this.bins.counts.length - 3, 0.01, 0.99);
        final long[] percentiles = oldBins.getQuantiles(DEFAULT_QUANTILES);
        final long count2 = oldBins.count.sum();
        return new Snapshot(){

            @Override
            public long[] getQuantiles(double[] quantiles) {
                return oldBins.getQuantiles(quantiles);
            }

            @Override
            public long[] getQuantiles() {
                return percentiles;
            }

            @Override
            public long getCount() {
                return count2;
            }

            @Override
            public long getCountAtOrBelow(long val) {
                return oldBins.getNumAtOrBelow(val);
            }

            @Override
            public long get25thPercentile() {
                return percentiles[0];
            }

            @Override
            public long get75thPercentile() {
                return percentiles[2];
            }

            @Override
            public long get90thPercentile() {
                return percentiles[3];
            }

            @Override
            public long get95thPercentile() {
                return percentiles[4];
            }

            @Override
            public long get98thPercentile() {
                return percentiles[5];
            }

            @Override
            public long get99thPercentile() {
                return percentiles[6];
            }

            @Override
            public long get999thPercentile() {
                return percentiles[7];
            }

            @Override
            public long getMedian() {
                return percentiles[1];
            }

            @Override
            public long getMax() {
                return oldBins.max.get();
            }

            @Override
            public long getMean() {
                return oldBins.getMean();
            }

            @Override
            public long getMin() {
                return oldBins.getMin();
            }
        };
    }

    private static class Bins {
        private final LongAdder[] counts;
        private final long binsMin;
        private final long binsMax;
        private final long bins10XMax;
        private final AtomicLong min = new AtomicLong(Long.MAX_VALUE);
        private final AtomicLong max = new AtomicLong(0L);
        private final LongAdder count = new LongAdder();
        private final LongAdder total = new LongAdder();
        private volatile boolean hasData = false;

        public Bins(int numBins) {
            this.counts = this.createCounters(numBins);
            this.binsMin = 1L;
            this.binsMax = 1000L;
            this.bins10XMax = this.binsMax * 10L;
        }

        public Bins(Bins last2, int numBins, double minQ, double maxQ) {
            long[] values = last2.getQuantiles(new double[]{minQ, maxQ});
            long wd = values[1] - values[0] + 1L;
            this.binsMin = Math.max(0L, (long)((double)values[0] - (double)wd * minQ));
            long binsMax = (long)((double)values[1] + (double)wd * (1.0 - maxQ)) + 1L;
            this.binsMax = Math.max(binsMax, this.binsMin + (long)numBins);
            this.bins10XMax = Math.max(values[1] + (binsMax - 1L) * 9L, this.binsMax + 1L);
            this.counts = this.createCounters(numBins);
        }

        private LongAdder[] createCounters(int numBins) {
            return (LongAdder[])Stream.generate(LongAdder::new).limit(numBins + 3).toArray(LongAdder[]::new);
        }

        private int getIndex(long value2) {
            if (value2 < this.binsMin) {
                return 0;
            }
            if (value2 > this.bins10XMax) {
                return this.counts.length - 1;
            }
            if (value2 >= this.binsMax) {
                return this.counts.length - 2;
            }
            return 1 + (int)((value2 - this.binsMin) * (long)(this.counts.length - 3) / (this.binsMax - this.binsMin));
        }

        public void add(long value2, long count2) {
            if (value2 < 0L) {
                return;
            }
            AtomicUtils.updateMin(this.min, value2);
            AtomicUtils.updateMax(this.max, value2);
            this.count.add(count2);
            this.total.add(value2 * count2);
            int pos2 = this.getIndex(value2);
            this.counts[pos2].add(count2);
            this.hasData = true;
        }

        public long[] getQuantiles(double[] quantiles) {
            if (!this.hasData) {
                return new long[quantiles.length];
            }
            long[] counts = new long[this.counts.length];
            long total2 = 0L;
            for (int i2 = 0; i2 < this.counts.length; ++i2) {
                counts[i2] = this.counts[i2].sum();
                total2 += counts[i2];
            }
            int rIndex = 0;
            double qCount = (double)total2 * quantiles[0];
            long cum = 0L;
            long[] res = new long[quantiles.length];
            block1: for (int i3 = 0; i3 < counts.length; ++i3) {
                long mx;
                long mn;
                if (i3 == 0) {
                    mn = this.min.get();
                    mx = this.binsMin;
                } else if (i3 == counts.length - 1) {
                    mn = this.bins10XMax;
                    mx = this.max.get();
                } else if (i3 == counts.length - 2) {
                    mn = this.binsMax;
                    mx = this.bins10XMax;
                } else {
                    mn = this.binsMin + (long)(i3 - 1) * (this.binsMax - this.binsMin) / (long)(this.counts.length - 3);
                    mx = this.binsMin + (long)i3 * (this.binsMax - this.binsMin) / (long)(this.counts.length - 3);
                }
                if (mx < this.min.get()) continue;
                if (mn > this.max.get()) break;
                mn = Math.max(mn, this.min.get());
                mx = Math.min(mx, this.max.get());
                double lastCum = cum;
                cum += counts[i3];
                while (qCount <= (double)cum) {
                    res[rIndex] = (double)cum == lastCum ? mn : (long)((qCount - lastCum) * (double)(mx - mn) / ((double)cum - lastCum) + (double)mn);
                    if (++rIndex >= quantiles.length) break block1;
                    qCount = (double)total2 * quantiles[rIndex];
                }
            }
            while (rIndex < quantiles.length) {
                res[rIndex] = this.max.get();
                ++rIndex;
            }
            return res;
        }

        long getNumAtOrBelow(long val) {
            return Arrays.stream(this.counts).mapToLong(c -> c.sum()).limit(this.getIndex(val) + 1).sum();
        }

        public long getMin() {
            long min2 = this.min.get();
            return min2 == Long.MAX_VALUE ? 0L : min2;
        }

        public long getMean() {
            long count2 = this.count.sum();
            long total2 = this.total.sum();
            if (count2 == 0L) {
                return 0L;
            }
            return total2 / count2;
        }
    }
}

