/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hbase.metrics.MetricRegistries;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryFactory;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.impl.MetricRegistryFactoryImpl;
import org.apache.hadoop.hbase.metrics.impl.RefCountingMap;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricRegistriesImpl
extends MetricRegistries {
    private final MetricRegistryFactory factory;
    private final RefCountingMap<MetricRegistryInfo, MetricRegistry> registries;

    public MetricRegistriesImpl() {
        this(new MetricRegistryFactoryImpl());
    }

    public MetricRegistriesImpl(MetricRegistryFactory factory) {
        this.factory = factory;
        this.registries = new RefCountingMap();
    }

    @Override
    public MetricRegistry create(MetricRegistryInfo info) {
        return this.registries.put(info, () -> this.factory.create(info));
    }

    @Override
    public boolean remove(MetricRegistryInfo key2) {
        return this.registries.remove(key2) == null;
    }

    @Override
    public Optional<MetricRegistry> get(MetricRegistryInfo info) {
        return Optional.ofNullable(this.registries.get(info));
    }

    @Override
    public Collection<MetricRegistry> getMetricRegistries() {
        return Collections.unmodifiableCollection(this.registries.values());
    }

    @Override
    public void clear() {
        this.registries.clear();
    }

    @Override
    public Set<MetricRegistryInfo> getMetricRegistryInfos() {
        return Collections.unmodifiableSet(this.registries.keySet());
    }
}

