/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.com.google.common.io;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import org.apache.hbase.thirdparty.com.google.common.annotations.GwtIncompatible;

@GwtIncompatible
abstract class LineBuffer {
    private StringBuilder line = new StringBuilder();
    private boolean sawReturn;

    LineBuffer() {
    }

    protected void add(char[] cbuf, int off, int len) throws IOException {
        int pos2 = off;
        if (this.sawReturn && len > 0 && this.finishLine(cbuf[pos2] == '\n')) {
            ++pos2;
        }
        int start2 = pos2;
        int end2 = off + len;
        while (pos2 < end2) {
            switch (cbuf[pos2]) {
                case '\r': {
                    this.line.append(cbuf, start2, pos2 - start2);
                    this.sawReturn = true;
                    if (pos2 + 1 < end2 && this.finishLine(cbuf[pos2 + 1] == '\n')) {
                        ++pos2;
                    }
                    start2 = pos2 + 1;
                    break;
                }
                case '\n': {
                    this.line.append(cbuf, start2, pos2 - start2);
                    this.finishLine(true);
                    start2 = pos2 + 1;
                    break;
                }
            }
            ++pos2;
        }
        this.line.append(cbuf, start2, off + len - start2);
    }

    @CanIgnoreReturnValue
    private boolean finishLine(boolean sawNewline) throws IOException {
        String separator = this.sawReturn ? (sawNewline ? "\r\n" : "\r") : (sawNewline ? "\n" : "");
        this.handleLine(this.line.toString(), separator);
        this.line = new StringBuilder();
        this.sawReturn = false;
        return sawNewline;
    }

    protected void finish() throws IOException {
        if (this.sawReturn || this.line.length() > 0) {
            this.finishLine(false);
        }
    }

    protected abstract void handleLine(String var1, String var2) throws IOException;
}

