/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.handler.codec.http2;

import org.apache.hbase.thirdparty.io.netty.handler.codec.http2.HpackUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

class HpackHeaderField {
    static final int HEADER_ENTRY_OVERHEAD = 32;
    final CharSequence name;
    final CharSequence value;

    static long sizeOf(CharSequence name2, CharSequence value2) {
        return name2.length() + value2.length() + 32;
    }

    HpackHeaderField(CharSequence name2, CharSequence value2) {
        this.name = ObjectUtil.checkNotNull(name2, "name");
        this.value = ObjectUtil.checkNotNull(value2, "value");
    }

    final int size() {
        return this.name.length() + this.value.length() + 32;
    }

    public final boolean equalsForTest(HpackHeaderField other) {
        return HpackUtil.equalsVariableTime(this.name, other.name) && HpackUtil.equalsVariableTime(this.value, other.value);
    }

    public String toString() {
        return this.name + ": " + this.value;
    }
}

