/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.resolver.dns;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.handler.codec.dns.DnsRecord;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.AuthoritativeDnsServerCache;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsCache;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsCacheEntry;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.DnsServerAddressStream;
import org.apache.hbase.thirdparty.io.netty.resolver.dns.SequentialDnsServerAddressStream;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

final class AuthoritativeDnsServerCacheAdapter
implements AuthoritativeDnsServerCache {
    private static final DnsRecord[] EMPTY = new DnsRecord[0];
    private final DnsCache cache;

    AuthoritativeDnsServerCacheAdapter(DnsCache cache) {
        this.cache = ObjectUtil.checkNotNull(cache, "cache");
    }

    @Override
    public DnsServerAddressStream get(String hostname) {
        List<? extends DnsCacheEntry> entries2 = this.cache.get(hostname, EMPTY);
        if (entries2 == null || entries2.isEmpty()) {
            return null;
        }
        if (entries2.get(0).cause() != null) {
            return null;
        }
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(entries2.size());
        int i2 = 0;
        do {
            InetAddress addr2 = entries2.get(i2).address();
            addresses.add(new InetSocketAddress(addr2, 53));
        } while (++i2 < entries2.size());
        return new SequentialDnsServerAddressStream(addresses, 0);
    }

    @Override
    public void cache(String hostname, InetSocketAddress address2, long originalTtl, EventLoop loop2) {
        if (!address2.isUnresolved()) {
            this.cache.cache(hostname, EMPTY, address2.getAddress(), originalTtl, loop2);
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean clear(String hostname) {
        return this.cache.clear(hostname);
    }
}

