/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.hbase.thirdparty.io.netty.util.Attribute;
import org.apache.hbase.thirdparty.io.netty.util.AttributeKey;
import org.apache.hbase.thirdparty.io.netty.util.AttributeMap;
import org.apache.hbase.thirdparty.io.netty.util.internal.ObjectUtil;

public class DefaultAttributeMap
implements AttributeMap {
    private static final AtomicReferenceFieldUpdater<DefaultAttributeMap, DefaultAttribute[]> ATTRIBUTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttributeMap.class, DefaultAttribute[].class, "attributes");
    private static final DefaultAttribute[] EMPTY_ATTRIBUTES = new DefaultAttribute[0];
    private volatile DefaultAttribute[] attributes = EMPTY_ATTRIBUTES;

    private static int searchAttributeByKey(DefaultAttribute[] sortedAttributes, AttributeKey<?> key2) {
        int low = 0;
        int high = sortedAttributes.length - 1;
        while (low <= high) {
            boolean searchRight;
            int mid = low + high >>> 1;
            DefaultAttribute midVal = sortedAttributes[mid];
            AttributeKey midValKey = midVal.key;
            if (midValKey == key2) {
                return mid;
            }
            int midValKeyId = midValKey.id();
            int keyId = key2.id();
            assert (midValKeyId != keyId);
            boolean bl = searchRight = midValKeyId < keyId;
            if (searchRight) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    private static void orderedCopyOnInsert(DefaultAttribute[] sortedSrc, int srcLength, DefaultAttribute[] copy, DefaultAttribute toInsert) {
        int i2;
        int id2 = toInsert.key.id();
        for (i2 = srcLength - 1; i2 >= 0; --i2) {
            DefaultAttribute attribute = sortedSrc[i2];
            assert (attribute.key.id() != id2);
            if (attribute.key.id() < id2) break;
            copy[i2 + 1] = sortedSrc[i2];
        }
        copy[i2 + 1] = toInsert;
        int toCopy = i2 + 1;
        if (toCopy > 0) {
            System.arraycopy(sortedSrc, 0, copy, 0, toCopy);
        }
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> key2) {
        DefaultAttribute[] newAttributes;
        DefaultAttribute[] attributes;
        ObjectUtil.checkNotNull(key2, "key");
        DefaultAttribute<T> newAttribute = null;
        do {
            int index2;
            if ((index2 = DefaultAttributeMap.searchAttributeByKey(attributes = this.attributes, key2)) >= 0) {
                DefaultAttribute attribute = attributes[index2];
                assert (attribute.key() == key2);
                if (!attribute.isRemoved()) {
                    return attribute;
                }
                if (newAttribute == null) {
                    newAttribute = new DefaultAttribute<T>(this, key2);
                }
                int count2 = attributes.length;
                newAttributes = Arrays.copyOf(attributes, count2);
                newAttributes[index2] = newAttribute;
                continue;
            }
            if (newAttribute == null) {
                newAttribute = new DefaultAttribute<T>(this, key2);
            }
            int count3 = attributes.length;
            newAttributes = new DefaultAttribute[count3 + 1];
            DefaultAttributeMap.orderedCopyOnInsert(attributes, count3, newAttributes, newAttribute);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, attributes, newAttributes));
        return newAttribute;
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> key2) {
        ObjectUtil.checkNotNull(key2, "key");
        return DefaultAttributeMap.searchAttributeByKey(this.attributes, key2) >= 0;
    }

    private <T> void removeAttributeIfMatch(AttributeKey<T> key2, DefaultAttribute<T> value2) {
        DefaultAttribute[] newAttributes;
        DefaultAttribute[] attributes;
        do {
            int index2;
            if ((index2 = DefaultAttributeMap.searchAttributeByKey(attributes = this.attributes, key2)) < 0) {
                return;
            }
            DefaultAttribute attribute = attributes[index2];
            assert (attribute.key() == key2);
            if (attribute != value2) {
                return;
            }
            int count2 = attributes.length;
            int newCount = count2 - 1;
            newAttributes = newCount == 0 ? EMPTY_ATTRIBUTES : new DefaultAttribute[newCount];
            System.arraycopy(attributes, 0, newAttributes, 0, index2);
            int remaining = count2 - index2 - 1;
            if (remaining <= 0) continue;
            System.arraycopy(attributes, index2 + 1, newAttributes, index2, remaining);
        } while (!ATTRIBUTES_UPDATER.compareAndSet(this, attributes, newAttributes));
    }

    private static final class DefaultAttribute<T>
    extends AtomicReference<T>
    implements Attribute<T> {
        private static final AtomicReferenceFieldUpdater<DefaultAttribute, DefaultAttributeMap> MAP_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultAttribute.class, DefaultAttributeMap.class, "attributeMap");
        private static final long serialVersionUID = -2661411462200283011L;
        private volatile DefaultAttributeMap attributeMap;
        private final AttributeKey<T> key;

        DefaultAttribute(DefaultAttributeMap attributeMap, AttributeKey<T> key2) {
            this.attributeMap = attributeMap;
            this.key = key2;
        }

        @Override
        public AttributeKey<T> key() {
            return this.key;
        }

        private boolean isRemoved() {
            return this.attributeMap == null;
        }

        @Override
        public T setIfAbsent(T value2) {
            while (!this.compareAndSet(null, value2)) {
                Object old = this.get();
                if (old == null) continue;
                return (T)old;
            }
            return null;
        }

        @Override
        public T getAndRemove() {
            DefaultAttributeMap attributeMap = this.attributeMap;
            boolean removed = attributeMap != null && MAP_UPDATER.compareAndSet(this, attributeMap, null);
            T oldValue = this.getAndSet(null);
            if (removed) {
                attributeMap.removeAttributeIfMatch(this.key, this);
            }
            return oldValue;
        }

        @Override
        public void remove() {
            DefaultAttributeMap attributeMap = this.attributeMap;
            boolean removed = attributeMap != null && MAP_UPDATER.compareAndSet(this, attributeMap, null);
            this.set(null);
            if (removed) {
                attributeMap.removeAttributeIfMatch(this.key, this);
            }
        }
    }
}

