/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal;

import org.apache.hbase.thirdparty.io.netty.util.concurrent.Promise;
import org.apache.hbase.thirdparty.io.netty.util.internal.ThrowableUtil;
import org.apache.hbase.thirdparty.io.netty.util.internal.logging.InternalLogger;

public final class PromiseNotificationUtil {
    private PromiseNotificationUtil() {
    }

    public static void tryCancel(Promise<?> p2, InternalLogger logger) {
        if (!p2.cancel(false) && logger != null) {
            Throwable err = p2.cause();
            if (err == null) {
                logger.warn("Failed to cancel promise because it has succeeded already: {}", (Object)p2);
            } else {
                logger.warn("Failed to cancel promise because it has failed already: {}, unnotified cause:", (Object)p2, (Object)err);
            }
        }
    }

    public static <V> void trySuccess(Promise<? super V> p2, V result2, InternalLogger logger) {
        if (!p2.trySuccess(result2) && logger != null) {
            Throwable err = p2.cause();
            if (err == null) {
                logger.warn("Failed to mark a promise as success because it has succeeded already: {}", (Object)p2);
            } else {
                logger.warn("Failed to mark a promise as success because it has failed already: {}, unnotified cause:", (Object)p2, (Object)err);
            }
        }
    }

    public static void tryFailure(Promise<?> p2, Throwable cause2, InternalLogger logger) {
        if (!p2.tryFailure(cause2) && logger != null) {
            Throwable err = p2.cause();
            if (err == null) {
                logger.warn("Failed to mark a promise as failure because it has succeeded already: {}", (Object)p2, (Object)cause2);
            } else if (logger.isWarnEnabled()) {
                logger.warn("Failed to mark a promise as failure because it has failed already: {}, unnotified cause: {}", p2, ThrowableUtil.stackTraceToString(err), cause2);
            }
        }
    }
}

