/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.util;

import org.apache.hbase.thirdparty.io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;

public final class UnsafeRefArrayAccess {
    public static final long REF_ARRAY_BASE;
    public static final int REF_ELEMENT_SHIFT;

    public static <E> void spRefElement(E[] buffer, long offset2, E e) {
        UnsafeAccess.UNSAFE.putObject(buffer, offset2, e);
    }

    public static <E> void soRefElement(E[] buffer, long offset2, E e) {
        UnsafeAccess.UNSAFE.putOrderedObject(buffer, offset2, e);
    }

    public static <E> E lpRefElement(E[] buffer, long offset2) {
        return (E)UnsafeAccess.UNSAFE.getObject(buffer, offset2);
    }

    public static <E> E lvRefElement(E[] buffer, long offset2) {
        return (E)UnsafeAccess.UNSAFE.getObjectVolatile(buffer, offset2);
    }

    public static long calcRefElementOffset(long index2) {
        return REF_ARRAY_BASE + (index2 << REF_ELEMENT_SHIFT);
    }

    public static long calcCircularRefElementOffset(long index2, long mask) {
        return REF_ARRAY_BASE + ((index2 & mask) << REF_ELEMENT_SHIFT);
    }

    public static <E> E[] allocateRefArray(int capacity) {
        return new Object[capacity];
    }

    static {
        int scale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size: " + scale);
        }
        REF_ARRAY_BASE = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    }
}

