/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.apache.commons.collections4.list;

import java.util.List;
import java.util.Objects;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.Factory;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.Transformer;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.list.AbstractSerializableListDecorator;

public class LazyList<E>
extends AbstractSerializableListDecorator<E> {
    private static final long serialVersionUID = -3677737457567429713L;
    private final Factory<? extends E> factory;
    private final Transformer<Integer, ? extends E> transformer;

    public static <E> LazyList<E> lazyList(List<E> list2, Factory<? extends E> factory) {
        return new LazyList<E>(list2, factory);
    }

    public static <E> LazyList<E> lazyList(List<E> list2, Transformer<Integer, ? extends E> transformer) {
        return new LazyList<E>(list2, transformer);
    }

    protected LazyList(List<E> list2, Factory<? extends E> factory) {
        super(list2);
        this.factory = Objects.requireNonNull(factory);
        this.transformer = null;
    }

    protected LazyList(List<E> list2, Transformer<Integer, ? extends E> transformer) {
        super(list2);
        this.factory = null;
        this.transformer = Objects.requireNonNull(transformer);
    }

    @Override
    public E get(int index2) {
        int size2 = this.decorated().size();
        if (index2 < size2) {
            Object object = this.decorated().get(index2);
            if (object == null) {
                object = this.element(index2);
                this.decorated().set(index2, object);
                return object;
            }
            return object;
        }
        for (int i2 = size2; i2 < index2; ++i2) {
            this.decorated().add(null);
        }
        E object = this.element(index2);
        this.decorated().add(object);
        return object;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List sub3 = this.decorated().subList(fromIndex, toIndex);
        if (this.factory != null) {
            return new LazyList<E>(sub3, this.factory);
        }
        if (this.transformer != null) {
            return new LazyList<E>(sub3, this.transformer);
        }
        throw new IllegalStateException("Factory and Transformer are both null!");
    }

    private E element(int index2) {
        if (this.factory != null) {
            return this.factory.create();
        }
        if (this.transformer != null) {
            return this.transformer.transform(index2);
        }
        throw new IllegalStateException("Factory and Transformer are both null!");
    }
}

