/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.zookeeper.server.ExpiryQueue;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.RateLogger;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.WorkerService;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxnFactory
extends ServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnFactory.class);
    public static final String ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT = "zookeeper.nio.sessionlessCnxnTimeout";
    public static final String ZOOKEEPER_NIO_NUM_SELECTOR_THREADS = "zookeeper.nio.numSelectorThreads";
    public static final String ZOOKEEPER_NIO_NUM_WORKER_THREADS = "zookeeper.nio.numWorkerThreads";
    public static final String ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES = "zookeeper.nio.directBufferBytes";
    public static final String ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT = "zookeeper.nio.shutdownTimeout";
    ServerSocketChannel ss;
    private static final ThreadLocal<ByteBuffer> directBuffer;
    private final ConcurrentHashMap<Long, NIOServerCnxn> sessionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new ConcurrentHashMap();
    protected int maxClientCnxns = 60;
    int sessionlessCnxnTimeout;
    private ExpiryQueue<NIOServerCnxn> cnxnExpiryQueue;
    protected WorkerService workerPool;
    private static int directBufferBytes;
    private int numSelectorThreads;
    private int numWorkerThreads;
    private long workerShutdownTimeoutMS;
    private volatile boolean stopped = true;
    private ConnectionExpirerThread expirerThread;
    private AcceptThread acceptThread;
    private final Set<SelectorThread> selectorThreads = new HashSet<SelectorThread>();

    public static ByteBuffer getDirectBuffer() {
        return directBufferBytes > 0 ? directBuffer.get() : null;
    }

    @Override
    public void configure(InetSocketAddress addr2, int maxcc, boolean secure) throws IOException {
        if (secure) {
            throw new UnsupportedOperationException("SSL isn't supported in NIOServerCnxn");
        }
        this.configureSaslLogin();
        this.maxClientCnxns = maxcc;
        this.sessionlessCnxnTimeout = Integer.getInteger(ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT, 10000);
        this.cnxnExpiryQueue = new ExpiryQueue(this.sessionlessCnxnTimeout);
        this.expirerThread = new ConnectionExpirerThread();
        int numCores = Runtime.getRuntime().availableProcessors();
        this.numSelectorThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_SELECTOR_THREADS, Math.max((int)Math.sqrt((float)numCores / 2.0f), 1));
        if (this.numSelectorThreads < 1) {
            throw new IOException("numSelectorThreads must be at least 1");
        }
        this.numWorkerThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_WORKER_THREADS, 2 * numCores);
        this.workerShutdownTimeoutMS = Long.getLong(ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT, 5000L);
        LOG.info("Configuring NIO connection handler with " + this.sessionlessCnxnTimeout / 1000 + "s sessionless connection timeout, " + this.numSelectorThreads + " selector thread(s), " + (this.numWorkerThreads > 0 ? Integer.valueOf(this.numWorkerThreads) : "no") + " worker threads, and " + (directBufferBytes == 0 ? "gathered writes." : "" + directBufferBytes / 1024 + " kB direct buffers."));
        for (int i2 = 0; i2 < this.numSelectorThreads; ++i2) {
            this.selectorThreads.add(new SelectorThread(i2));
        }
        this.ss = ServerSocketChannel.open();
        this.ss.socket().setReuseAddress(true);
        LOG.info("binding to port " + addr2);
        this.ss.socket().bind(addr2);
        this.ss.configureBlocking(false);
        this.acceptThread = new AcceptThread(this.ss, addr2, this.selectorThreads);
    }

    private void tryClose(ServerSocketChannel s2) {
        try {
            s2.close();
        }
        catch (IOException sse) {
            LOG.error("Error while closing server socket.", sse);
        }
    }

    @Override
    public void reconfigure(InetSocketAddress addr2) {
        ServerSocketChannel oldSS = this.ss;
        try {
            this.acceptThread.setReconfiguring();
            this.tryClose(oldSS);
            this.acceptThread.wakeupSelector();
            try {
                this.acceptThread.join();
            }
            catch (InterruptedException e) {
                LOG.error("Error joining old acceptThread when reconfiguring client port {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
            this.ss = ServerSocketChannel.open();
            this.ss.socket().setReuseAddress(true);
            LOG.info("binding to port " + addr2);
            this.ss.socket().bind(addr2);
            this.ss.configureBlocking(false);
            this.acceptThread = new AcceptThread(this.ss, addr2, this.selectorThreads);
            this.acceptThread.start();
        }
        catch (IOException e) {
            LOG.error("Error reconfiguring client port to {} {}", (Object)addr2, (Object)e.getMessage());
            this.tryClose(oldSS);
        }
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max2) {
        this.maxClientCnxns = max2;
    }

    @Override
    public void start() {
        this.stopped = false;
        if (this.workerPool == null) {
            this.workerPool = new WorkerService("NIOWorker", this.numWorkerThreads, false);
        }
        for (SelectorThread thread : this.selectorThreads) {
            if (thread.getState() != Thread.State.NEW) continue;
            thread.start();
        }
        if (this.acceptThread.getState() == Thread.State.NEW) {
            this.acceptThread.start();
        }
        if (this.expirerThread.getState() == Thread.State.NEW) {
            this.expirerThread.start();
        }
    }

    @Override
    public void startup(ZooKeeperServer zks, boolean startServer) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zks);
        if (startServer) {
            zks.startdata();
            zks.startup();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ss.socket().getLocalPort();
    }

    public boolean removeCnxn(NIOServerCnxn cnxn) {
        Set<NIOServerCnxn> set;
        InetAddress addr2;
        if (!this.cnxns.remove(cnxn)) {
            return false;
        }
        this.cnxnExpiryQueue.remove(cnxn);
        long sessionId = cnxn.getSessionId();
        if (sessionId != 0L) {
            this.sessionMap.remove(sessionId);
        }
        if ((addr2 = cnxn.getSocketAddress()) != null && (set = this.ipMap.get(addr2)) != null) {
            set.remove(cnxn);
        }
        this.unregisterConnection(cnxn);
        return true;
    }

    public void touchCnxn(NIOServerCnxn cnxn) {
        this.cnxnExpiryQueue.update(cnxn, cnxn.getSessionTimeout());
    }

    private void addCnxn(NIOServerCnxn cnxn) throws IOException {
        Set<NIOServerCnxn> existingSet;
        InetAddress addr2 = cnxn.getSocketAddress();
        if (addr2 == null) {
            throw new IOException("Socket of " + cnxn + " has been closed");
        }
        Set<NIOServerCnxn> set = this.ipMap.get(addr2);
        if (set == null && (existingSet = this.ipMap.putIfAbsent(addr2, set = Collections.newSetFromMap(new ConcurrentHashMap(2)))) != null) {
            set = existingSet;
        }
        set.add(cnxn);
        this.cnxns.add(cnxn);
        this.touchCnxn(cnxn);
    }

    protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk, SelectorThread selectorThread) throws IOException {
        return new NIOServerCnxn(this.zkServer, sock, sk, this, selectorThread);
    }

    private int getClientCnxnCount(InetAddress cl) {
        Set<NIOServerCnxn> s2 = this.ipMap.get(cl);
        if (s2 == null) {
            return 0;
        }
        return s2.size();
    }

    @Override
    public void closeAll() {
        for (ServerCnxn cnxn : this.cnxns) {
            try {
                cnxn.close();
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception closing cnxn sessionid 0x" + Long.toHexString(cnxn.getSessionId()), e);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        try {
            this.ss.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing listen socket", e);
        }
        if (this.acceptThread != null) {
            if (this.acceptThread.isAlive()) {
                this.acceptThread.wakeupSelector();
            } else {
                this.acceptThread.closeSelector();
            }
        }
        if (this.expirerThread != null) {
            this.expirerThread.interrupt();
        }
        for (SelectorThread thread : this.selectorThreads) {
            if (thread.isAlive()) {
                thread.wakeupSelector();
                continue;
            }
            thread.closeSelector();
        }
        if (this.workerPool != null) {
            this.workerPool.stop();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.stop();
            this.join();
            this.closeAll();
            if (this.login != null) {
                this.login.shutdown();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Ignoring interrupted exception during shutdown", e);
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", e);
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
    }

    public void addSession(long sessionId, NIOServerCnxn cnxn) {
        this.sessionMap.put(sessionId, cnxn);
    }

    @Override
    public boolean closeSession(long sessionId) {
        NIOServerCnxn cnxn = this.sessionMap.remove(sessionId);
        if (cnxn != null) {
            cnxn.close();
            return true;
        }
        return false;
    }

    @Override
    public void join() throws InterruptedException {
        if (this.acceptThread != null) {
            this.acceptThread.join();
        }
        for (SelectorThread thread : this.selectorThreads) {
            thread.join();
        }
        if (this.workerPool != null) {
            this.workerPool.join(this.workerShutdownTimeoutMS);
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    public void dumpConnections(PrintWriter pwriter) {
        pwriter.print("Connections ");
        this.cnxnExpiryQueue.dump(pwriter);
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn c : this.cnxns) {
            c.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean brief) {
        HashSet<Map<String, Object>> info = new HashSet<Map<String, Object>>();
        for (ServerCnxn c : this.cnxns) {
            info.add(c.getConnectionInfo(brief));
        }
        return info;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOG.error("Thread " + t + " died", e);
            }
        });
        try {
            Selector.open().close();
        }
        catch (IOException ie) {
            LOG.error("Selector failed to open", ie);
        }
        directBufferBytes = Integer.getInteger(ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES, 65536);
        directBuffer = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocateDirect(directBufferBytes);
            }
        };
    }

    private class ConnectionExpirerThread
    extends ZooKeeperThread {
        ConnectionExpirerThread() {
            super("ConnnectionExpirer");
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped) {
                    long waitTime = NIOServerCnxnFactory.this.cnxnExpiryQueue.getWaitTime();
                    if (waitTime > 0L) {
                        Thread.sleep(waitTime);
                        continue;
                    }
                    for (NIOServerCnxn conn : NIOServerCnxnFactory.this.cnxnExpiryQueue.poll()) {
                        conn.close();
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.info("ConnnectionExpirerThread interrupted");
            }
        }
    }

    private class IOWorkRequest
    extends WorkerService.WorkRequest {
        private final SelectorThread selectorThread;
        private final SelectionKey key;
        private final NIOServerCnxn cnxn;

        IOWorkRequest(SelectorThread selectorThread, SelectionKey key2) {
            this.selectorThread = selectorThread;
            this.key = key2;
            this.cnxn = (NIOServerCnxn)key2.attachment();
        }

        @Override
        public void doWork() throws InterruptedException {
            if (!this.key.isValid()) {
                this.selectorThread.cleanupSelectionKey(this.key);
                return;
            }
            if (this.key.isReadable() || this.key.isWritable()) {
                this.cnxn.doIO(this.key);
                if (NIOServerCnxnFactory.this.stopped) {
                    this.cnxn.close();
                    return;
                }
                if (!this.key.isValid()) {
                    this.selectorThread.cleanupSelectionKey(this.key);
                    return;
                }
                NIOServerCnxnFactory.this.touchCnxn(this.cnxn);
            }
            this.cnxn.enableSelectable();
            if (!this.selectorThread.addInterestOpsUpdateRequest(this.key)) {
                this.cnxn.close();
            }
        }

        @Override
        public void cleanup() {
            this.cnxn.close();
        }
    }

    class SelectorThread
    extends AbstractSelectThread {
        private final int id;
        private final Queue<SocketChannel> acceptedQueue;
        private final Queue<SelectionKey> updateQueue;

        public SelectorThread(int id2) throws IOException {
            super("NIOServerCxnFactory.SelectorThread-" + id2);
            this.id = id2;
            this.acceptedQueue = new LinkedBlockingQueue<SocketChannel>();
            this.updateQueue = new LinkedBlockingQueue<SelectionKey>();
        }

        public boolean addAcceptedConnection(SocketChannel accepted) {
            if (NIOServerCnxnFactory.this.stopped || !this.acceptedQueue.offer(accepted)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        public boolean addInterestOpsUpdateRequest(SelectionKey sk) {
            if (NIOServerCnxnFactory.this.stopped || !this.updateQueue.offer(sk)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketChannel accepted;
                while (!NIOServerCnxnFactory.this.stopped) {
                    try {
                        this.select();
                        this.processAcceptedConnections();
                        this.processInterestOpsUpdateRequests();
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Ignoring unexpected runtime exception", e);
                    }
                    catch (Exception e) {
                        LOG.warn("Ignoring unexpected exception", e);
                    }
                }
                for (SelectionKey key2 : this.selector.keys()) {
                    NIOServerCnxn cnxn = (NIOServerCnxn)key2.attachment();
                    if (cnxn.isSelectable()) {
                        cnxn.close();
                    }
                    this.cleanupSelectionKey(key2);
                }
                while ((accepted = this.acceptedQueue.poll()) != null) {
                    this.fastCloseSock(accepted);
                }
                this.updateQueue.clear();
            }
            finally {
                this.closeSelector();
                NIOServerCnxnFactory.this.stop();
                LOG.info("selector thread exitted run method");
            }
        }

        private void select() {
            try {
                this.selector.select();
                Set<SelectionKey> selected = this.selector.selectedKeys();
                ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                Collections.shuffle(selectedList);
                Iterator<SelectionKey> selectedKeys = selectedList.iterator();
                while (!NIOServerCnxnFactory.this.stopped && selectedKeys.hasNext()) {
                    SelectionKey key2 = selectedKeys.next();
                    selected.remove(key2);
                    if (!key2.isValid()) {
                        this.cleanupSelectionKey(key2);
                        continue;
                    }
                    if (key2.isReadable() || key2.isWritable()) {
                        this.handleIO(key2);
                        continue;
                    }
                    LOG.warn("Unexpected ops in select " + key2.readyOps());
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring IOException while selecting", e);
            }
        }

        private void handleIO(SelectionKey key2) {
            IOWorkRequest workRequest = new IOWorkRequest(this, key2);
            NIOServerCnxn cnxn = (NIOServerCnxn)key2.attachment();
            cnxn.disableSelectable();
            key2.interestOps(0);
            NIOServerCnxnFactory.this.touchCnxn(cnxn);
            NIOServerCnxnFactory.this.workerPool.schedule(workRequest);
        }

        private void processAcceptedConnections() {
            SocketChannel accepted;
            while (!NIOServerCnxnFactory.this.stopped && (accepted = this.acceptedQueue.poll()) != null) {
                SelectionKey key2 = null;
                try {
                    key2 = accepted.register(this.selector, 1);
                    NIOServerCnxn cnxn = NIOServerCnxnFactory.this.createConnection(accepted, key2, this);
                    key2.attach(cnxn);
                    NIOServerCnxnFactory.this.addCnxn(cnxn);
                }
                catch (IOException e) {
                    this.cleanupSelectionKey(key2);
                    this.fastCloseSock(accepted);
                }
            }
        }

        private void processInterestOpsUpdateRequests() {
            SelectionKey key2;
            while (!NIOServerCnxnFactory.this.stopped && (key2 = this.updateQueue.poll()) != null) {
                NIOServerCnxn cnxn;
                if (!key2.isValid()) {
                    this.cleanupSelectionKey(key2);
                }
                if (!(cnxn = (NIOServerCnxn)key2.attachment()).isSelectable()) continue;
                key2.interestOps(cnxn.getInterestOps());
            }
        }
    }

    private class AcceptThread
    extends AbstractSelectThread {
        private final ServerSocketChannel acceptSocket;
        private final SelectionKey acceptKey;
        private final RateLogger acceptErrorLogger;
        private final Collection<SelectorThread> selectorThreads;
        private Iterator<SelectorThread> selectorIterator;
        private volatile boolean reconfiguring;

        public AcceptThread(ServerSocketChannel ss, InetSocketAddress addr2, Set<SelectorThread> selectorThreads) throws IOException {
            super("NIOServerCxnFactory.AcceptThread:" + addr2);
            this.acceptErrorLogger = new RateLogger(LOG);
            this.reconfiguring = false;
            this.acceptSocket = ss;
            this.acceptKey = this.acceptSocket.register(this.selector, 16);
            this.selectorThreads = Collections.unmodifiableList(new ArrayList<SelectorThread>(selectorThreads));
            this.selectorIterator = this.selectorThreads.iterator();
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped && !this.acceptSocket.socket().isClosed()) {
                    try {
                        this.select();
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Ignoring unexpected runtime exception", e);
                    }
                    catch (Exception e) {
                        LOG.warn("Ignoring unexpected exception", e);
                    }
                }
            }
            finally {
                this.closeSelector();
                if (!this.reconfiguring) {
                    NIOServerCnxnFactory.this.stop();
                }
                LOG.info("accept thread exitted run method");
            }
        }

        public void setReconfiguring() {
            this.reconfiguring = true;
        }

        private void select() {
            try {
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (!NIOServerCnxnFactory.this.stopped && selectedKeys.hasNext()) {
                    SelectionKey key2 = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key2.isValid()) continue;
                    if (key2.isAcceptable()) {
                        if (this.doAccept()) continue;
                        this.pauseAccept(10L);
                        continue;
                    }
                    LOG.warn("Unexpected ops in accept select " + key2.readyOps());
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring IOException while selecting", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pauseAccept(long millisecs) {
            this.acceptKey.interestOps(0);
            try {
                this.selector.select(millisecs);
            }
            catch (IOException iOException) {
            }
            finally {
                this.acceptKey.interestOps(16);
            }
        }

        private boolean doAccept() {
            boolean accepted = false;
            SocketChannel sc = null;
            try {
                SelectorThread selectorThread;
                sc = this.acceptSocket.accept();
                accepted = true;
                InetAddress ia = sc.socket().getInetAddress();
                int cnxncount = NIOServerCnxnFactory.this.getClientCnxnCount(ia);
                if (NIOServerCnxnFactory.this.maxClientCnxns > 0 && cnxncount >= NIOServerCnxnFactory.this.maxClientCnxns) {
                    throw new IOException("Too many connections from " + ia + " - max is " + NIOServerCnxnFactory.this.maxClientCnxns);
                }
                LOG.debug("Accepted socket connection from " + sc.socket().getRemoteSocketAddress());
                sc.configureBlocking(false);
                if (!this.selectorIterator.hasNext()) {
                    this.selectorIterator = this.selectorThreads.iterator();
                }
                if (!(selectorThread = this.selectorIterator.next()).addAcceptedConnection(sc)) {
                    throw new IOException("Unable to add connection to selector queue" + (NIOServerCnxnFactory.this.stopped ? " (shutdown in progress)" : ""));
                }
                this.acceptErrorLogger.flush();
            }
            catch (IOException e) {
                this.acceptErrorLogger.rateLimitLog("Error accepting new connection: " + e.getMessage());
                this.fastCloseSock(sc);
            }
            return accepted;
        }
    }

    private abstract class AbstractSelectThread
    extends ZooKeeperThread {
        protected final Selector selector;

        public AbstractSelectThread(String name2) throws IOException {
            super(name2);
            this.setDaemon(true);
            this.selector = Selector.open();
        }

        public void wakeupSelector() {
            this.selector.wakeup();
        }

        protected void closeSelector() {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOG.warn("ignored exception during selector close " + e.getMessage());
            }
        }

        protected void cleanupSelectionKey(SelectionKey key2) {
            block3: {
                if (key2 != null) {
                    try {
                        key2.cancel();
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block3;
                        LOG.debug("ignoring exception during selectionkey cancel", ex);
                    }
                }
            }
        }

        protected void fastCloseSock(SocketChannel sc) {
            if (sc != null) {
                try {
                    sc.socket().setSoLinger(true, 0);
                }
                catch (SocketException e) {
                    LOG.warn("Unable to set socket linger to 0, socket close may stall in CLOSE_WAIT", e);
                }
                NIOServerCnxn.closeSock(sc);
            }
        }
    }
}

