/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.RubyString;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.instructions.MultiOperandInstr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrAssignInstr
extends MultiOperandInstr {
    private Operand obj;
    private Operand attr;
    private Operand value;
    private Operand[] args;

    public AttrAssignInstr(Operand obj, Operand attr2, Operand[] args2) {
        super(Operation.ATTR_ASSIGN, null);
        this.obj = obj;
        this.attr = attr2;
        this.args = args2;
        this.value = null;
    }

    public AttrAssignInstr(Operand obj, Operand attr2, Operand[] args2, Operand value2) {
        super(Operation.ATTR_ASSIGN, null);
        this.obj = obj;
        this.attr = attr2;
        this.args = args2;
        this.value = value2;
    }

    @Override
    public Operand[] getOperands() {
        Operand[] argsArray = new Operand[this.args.length + (this.value == null ? 2 : 3)];
        int i2 = 2;
        argsArray[0] = this.obj;
        argsArray[1] = this.attr;
        if (this.value != null) {
            argsArray[2] = this.value;
            ++i2;
        }
        for (Operand o : this.args) {
            argsArray[i2++] = o;
        }
        return argsArray;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
        this.obj = this.obj.getSimplifiedOperand(valueMap);
        this.attr = this.attr.getSimplifiedOperand(valueMap);
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            this.args[i2] = this.args[i2].getSimplifiedOperand(valueMap);
        }
        if (this.value != null) {
            this.value = this.value.getSimplifiedOperand(valueMap);
        }
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        int i2 = 0;
        Operand[] clonedArgs = new Operand[this.args.length];
        for (Operand a : this.args) {
            clonedArgs[i2++] = a.cloneForInlining(ii);
        }
        return new AttrAssignInstr(this.obj.cloneForInlining(ii), this.attr.cloneForInlining(ii), clonedArgs, this.value == null ? null : this.value.cloneForInlining(ii));
    }

    @Override
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        IRubyObject receiver2 = (IRubyObject)this.obj.retrieve(interp);
        String attrMeth = ((RubyString)this.attr.retrieve(interp)).asJavaString();
        IRubyObject[] callArgs = new IRubyObject[this.args.length + (this.value == null ? 0 : 1)];
        int i2 = 0;
        if (this.value != null) {
            callArgs[0] = (IRubyObject)this.value.retrieve(interp);
            ++i2;
        }
        while (i2 < callArgs.length) {
            callArgs[i2] = (IRubyObject)this.args[i2].retrieve(interp);
            ++i2;
        }
        receiver2.callMethod(interp.getContext(), attrMeth, callArgs);
        return null;
    }
}

