/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.compiler.ir.operands.Variable;
import org.jruby.interpreter.InterpreterContext;

public class TemporaryVariable
extends Variable {
    final int offset;

    public TemporaryVariable(int offset2) {
        this.offset = offset2;
    }

    public String getName() {
        return this.getPrefix() + this.offset;
    }

    public int compareTo(Object other) {
        if (!(other instanceof TemporaryVariable)) {
            return 0;
        }
        TemporaryVariable temporary = (TemporaryVariable)other;
        int prefixCompare = this.getPrefix().compareTo(temporary.getPrefix());
        if (prefixCompare != 0) {
            return prefixCompare;
        }
        if (this.offset < temporary.offset) {
            return -1;
        }
        if (this.offset > temporary.offset) {
            return 1;
        }
        return 0;
    }

    public String getPrefix() {
        return "%v_";
    }

    public String toString() {
        return this.getPrefix() + this.offset;
    }

    public Object retrieve(InterpreterContext interp) {
        return interp.getTemporaryVariable(this.offset);
    }

    public Object store(InterpreterContext interp, Object value2) {
        return interp.setTemporaryVariable(this.offset, value2);
    }
}

