/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.js;

import java.util.List;
import javax.script.ScriptException;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprUndefFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.js.EnvJavaScript;
import org.apache.jena.sparql.function.js.NV;

public class FunctionJavaScript
extends FunctionBase {
    private final EnvJavaScript envJS;
    private final String functionName;
    private boolean initialized = false;

    public FunctionJavaScript(String functionName, EnvJavaScript env) {
        this.functionName = functionName;
        this.envJS = env;
    }

    @Override
    public void checkBuild(String uri, ExprList args) {
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        try {
            Object[] a = new Object[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                a[i] = NV.fromNodeValue(args.get(i));
            }
            Object r = this.envJS.call(this.functionName, a);
            if (r == null) {
                throw new ExprEvalException(this.functionName);
            }
            NodeValue nv = NV.toNodeValue(r);
            return nv;
        }
        catch (NoSuchMethodException ex) {
            throw new ExprUndefFunction("No such JavaScript function '" + this.functionName + "'", this.functionName);
        }
        catch (ScriptException e2) {
            throw new ExprEvalException("Failed to evaluate javascript function '" + this.functionName + "'", e2);
        }
    }
}

