/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorConcat;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphUnionRead
extends GraphBase {
    private final DatasetGraph dataset;
    private final Collection<Node> graphs;
    private final Node graphName;

    public GraphUnionRead(DatasetGraph dsg) {
        this(dsg, null);
    }

    public GraphUnionRead(DatasetGraph dsg, Collection<Node> graphs) {
        this.dataset = dsg;
        this.graphs = graphs;
        this.graphName = graphs != null && graphs.size() == 1 ? CollectionUtils.oneElt(graphs) : null;
    }

    @Override
    protected PrefixMapping createPrefixMapping() {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        this.forEachGraph(g -> {
            PrefixMapping pmapNamedGraph = g.getPrefixMapping();
            pmap.setNsPrefixes(pmapNamedGraph);
        });
        return pmap;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        if (this.graphs == null) {
            return GraphUnionRead.quadsToTriples(this.dataset, Quad.unionGraph, m);
        }
        if (this.graphs.isEmpty()) {
            return NullIterator.instance();
        }
        if (this.graphName != null) {
            if (!this.dataset.containsGraph(this.graphName)) {
                return NullIterator.instance();
            }
            return this.dataset.getGraph(this.graphName).find(m);
        }
        IteratorConcat iter = new IteratorConcat();
        this.forEachGraph(g -> iter.add(g.find(m)));
        return WrappedIterator.createNoRemove(Iter.distinct(iter));
    }

    private static ExtendedIterator<Triple> quadsToTriples(DatasetGraph dsg, Node graphName, Triple m) {
        Iterator<Quad> qIter = dsg.findNG(graphName, m.getSubject(), m.getPredicate(), m.getObject());
        Iterator<Triple> tIter = Iter.map(qIter, quad -> quad.asTriple());
        return WrappedIterator.createNoRemove(tIter);
    }

    private void forEachGraph(Consumer<Graph> action) {
        if (this.graphs == null) {
            this.dataset.listGraphNodes().forEachRemaining(gn -> action.accept(this.dataset.getGraph((Node)gn)));
            return;
        }
        this.graphs.stream().filter(gn -> this.dataset.containsGraph((Node)gn)).map(gn -> Quad.isDefaultGraph(gn) ? this.dataset.getDefaultGraph() : this.dataset.getGraph((Node)gn)).forEach(action);
    }

    @Override
    public void performAdd(Triple t) {
        throw new AddDeniedException("GraphUnionRead::performAdd - Read-only graph");
    }

    @Override
    public void performDelete(Triple t) {
        throw new DeleteDeniedException("GraphUnionRead::performDelete - Read-only graph");
    }
}

